: SCRIPT iDISbackup.ss
#
# Copyright 1986 Intel Corporation
#
# Makes a backup copy of certain critical files.
#
# User may add to (or delete from) the filelist.
#
# Change the value assigned to MAX to increase/decrease the number of
# earlier versions of the backup archive to be retained.
#
# This script may be run explicitly, but it is expected that more
# usually it will be executed via an entry in /usr/lib/crontab.
#
# The files listed are backed up into a single 'tar' archive
# which is given a meaningless numeric name.
#
# At any time, there will be <MAX + 1> archives in /iDISboot/backup.
# The most recent can be found by inspecting the output of the 'l' command.
#
# To restore a <file> from an <archive>, enter the command:
#
#	tar xf <archive> <file>
#

MAX=2

if [ ! -d /iDISboot/backup ] ; then
	mkdir /iDISboot/backup
fi
cd /iDISboot/backup

cat >/tmp/iDISbackup.lst <<-END
	/etc/passwd
	/etc/group
	/usr/iDIS/idis/develop/select.dat
	/usr/iDIS/idis/control/login.dat
	/usr/iDIS/idis/control/deauth.dat
	/net/cdf
	/net/data
	/net/self
	END
filelist=`cat /tmp/iDISbackup.lst`
rm /tmp/iDISbackup.lst

TOT=`ls [0-9]* 2>/dev/null | wc -l`
[ $TOT -gt $MAX ] && 
	OLD=`expr $TOT - $MAX` &&
	rm -f `ls -rt [0-9]* | head -$OLD`

nohup tar cf $$ $filelist 2>&1 >LOG &
