: 'Copyright 1986 Intel Corp.'
# Network Synchronization cleanup, called by /etc/rc
# Set up all environment variables net synch routines require
# 04/25/86 oer
# 05/08/86 oer change to use master node, set up additional environ variables
# 07/11/86 oer change Astage4.ss to Astage4
# 08/16/86 oer correct the Astage2.ss invocation

iDIS=/usr/iDIS		# NOTE: THIS IS HARD CODED !!!
iDISBIN=/usr/iDISbin	# and does not include the node name

PHYSYS=`cat /etc/systemid`

# see if can access with //$PHYSYS, if so OpenNET is installed
if [ -f //$PHYSYS/etc/systemid ] ; then
   OPENNET=y
   MASNODE=`sed -n -e 's/^\/\/\([^/]*\)\/etc\/passwd$/\1/p' /net/self`
   MASNODEP=//$MASNODE
   # if isn't the master node, exit.  We don't have any net synch files here
   case $PHYSYS in
      $MASNODE) ;;
      *)	exit 0 ;;
   esac
else
   OPENNET=n
   MASNODE=$PHYSYS
   MASNODEP=
fi

MASSYNCH=$MASNODEP/$iDIS/synch

export iDIS iDISBIN PHYSYS OPENNET MASNODE MASNODEP MASSYNCH

cd $MASSYNCH

echo "`date` system reboot, restart begin" >> $MASSYNCH/logfile

# for the applied queues:
#	if any lock files exist, touch them to make RESTART happen ASAP
#	if any final form txns exist, start Stage4

settime 1001120085 *.apply/*..L 2>/dev/null
if ls *.apply/*.*[0-9] > /dev/null 2>&1 ; then
   exec $iDISBIN/Astage4 &
   echo "`date` start Stage4" >> $MASSYNCH/logfile
fi


# for each work queue
#	if Stage1 file NOT there, remove all files
#	if Stage1 file there, see if Stage2 file exists
#		if Stage2 file NOT there, remove a final form txns, start Stage2
#		if Stage2 file there, start Stage3

for wq in .Sched.Batch `ls *.Batch`
do
   [ ! -d $MASSYNCH/$wq ] && continue
   cd $MASSYNCH/$wq

   # get LOGINID in a way that will work for the scheduled txn work queue
   ls *.idis? > /dev/null 2>&1 || continue	# primarily for .Sched.Batch
   set `ls *.idis?`
   LOGINID=`expr $1 : "\(.*\)\.idis."` export LOGINID

   if [ ! -f Stage1 ] ; then
      rm -rf *
      echo "`date` Restarted $wq, removed pre-Stage1 files" >> $MASSYNCH/logfile
      cat <<-HERE | mail -s "Last applied Batch lost following system restart" $LOGINID
	The last batch of transactions you applied was lost when the system
	was restarted.  You will need to recreate the transactions.  In some
	cases (such as adding users) you will need to first delete the results
	of work done prior to the system restart.  In these cases this is
	done by creating "xdel" (Delete) transactions.
	HERE
      continue
   fi

   if [ ! -f Stage2 ] ; then
      rm -f *.work/*.*[0-9]
      exec $iDISBIN/Astage2.ss $iDIS $iDISBIN $OPENNET $MASNODE $MASNODEP \
	 $MASSYNCH $LOGINID `pwd` &
      echo "`date` Restarted $wq, started Stage2 process" >> $MASSYNCH/logfile
      continue
   fi
   echo "`date` Restarted $wq, started Stage3 process" >> $MASSYNCH/logfile
   $iDISBIN/Astage3
   exec $iDISBIN/Astage4 &
done

echo "`date` system reboot, restart end" >> $MASSYNCH/logfile
