: /bin/sh
# ".rmidis.ss", a shell script to remove an iDIS system.

# Copyright 1986 Intel Corporation.

# 04/01/86  oer  Written for iDIS R.20.
# 05/28/86  gll  Revised to remove samples public workarea and
#                to remove iDIS entries into the /etc/rc file.
# 06/10/86  gll  Remove idis, ilna, idev, ikey, iuser, ademo,
#                iDIS, inst, shutdown, and samples login entries
#                from /etc/passwd.
# 07/02/86  gll  Corrected removal of idis from /etc/group.

# Double check that system is single-user (and user at the console)
# We don't want iDIS removed while someone is using it!
if [ "`who am i`" != "" ] ; then
	echo In order to use this shellscript you must be in single user mode.
	echo To put the system into single user mode, login as \'root\',
	echo from the console, and issue the following:
	echo "   /etc/shutdown su"
	exit 0
fi

# The user should be at the console, with the /usr file system mounted
# (17MB systems do not have a separate /usr file system)
if [ ! -d /usr/tmp ] ; then
	echo 'mounting /usr file system'
	/etc/mount /dev/usr /usr
	return=$?
	while [ $return = 2 ] ; do
		echo "Cleaning /dev/usr"
		fsck -y  /dev/usr
		echo 'mounting /usr file system'
		/etc/mount /dev/usr /usr
		return=$?
	done
fi

echo 'This will REMOVE an iDIS system, the public workarea,'
echo ' the /etc/drm directory (resource definitions and assignments),'
echo ' the user templates, personnel directory (phone book),'
echo ' and the users: idis, idev, ikey, iuser, ademo'
echo -n 'Do you want to do this (y or n)? '
read resp
case $resp in
	y) ;;
	*) exit ;;
esac
echo You will be put into vi to change the /etc/passwd and /etc/group files

echo 'Removing the iDIS system ...'
rm -rf /usr/iDIS
rm -rf /usr/iDISbin
rm -rf /iDISboot
echo 'Removing the Resource information'
rm -rf /etc/drm
echo 'Removing the user templates and phone book'
rm -rf /etc/Templates
rm -f  /etc/Personnel
sed -e "/^idis:/d" /etc/group > /etc/group.tmp
mv /etc/group.tmp /etc/group
for user in idis iDIS inst shutdown ilna idev ikey iuser ademo samples
do
	echo "Removing $user ..."
	rm -rf /usr/$user
	rm -f  /usr/spool/mail/$user
        sed -e "/^${user}:/d" /etc/passwd > /etc/passwd.tmp
        mv /etc/passwd.tmp /etc/passwd
done

echo "Removing iDIS invocations from /etc/rc ..."
sed -e '/^\/iDISboot/d' /etc/rc > /etc/rc.new
cp /etc/rc.new /etc/rc
rm -f /etc/rc.new

echo -n "
About to edit the /etc/passwd file to allow you to
remove unwanted user, group, and public workarea entries.

Press RETURN when ready to begin editing ..."
read resp
vi /etc/passwd

echo -n "
About to edit the /etc/group file to allow you to
remove unwanted group entries.

Press RETURN when ready to begin editing ..."
read resp
vi /etc/group

echo "
iDIS Removal complete
"
