/*
	   TITLE: cusnumname

	FUNCTION: Builds reference file of four pages each containing 1024
		  entries of customer names, indexed by customer number.
		  A pipe is opened. Whenever a reference to a customer is
	  	  requested through the pipe, the file or in memory page is
		  read and the name is piped out.

	   USAGE: Used by rtas to validate customer number entries from forms.

*/
# include <stdio.h>
# include <signal.h>
# include "custproc.h"

extern int unblock();
extern int procsig;

char  name[MAX_CUSTS][NAME_LEN];
char  perror[] =
"\"Invalid parameter to cusnumname proc: %s\" \"\" ";
char  error[] =
" \"NO CUSTOMER FOUND -- PLEASE TRY AGAIN ****\" \"\" +f \"%s=\" " ;
char  nothing[] = "\"\" \"\" ";
char  blank[] = "\"\" \"\" +f \"%s=\" ";

main( argc, argv, envp )
int argc;
char *argv[];
char *envp[];
{
	FILE  *cfd;
	char  buffer[BUFSIZ];
	char  fields[2][NAME_LEN];
	short i, number;
	char  *sud();
	char  *getenv();
	char  mess[100], *cptr, retname[30];
	int   Pread, Pwrite, Cread, Cwrite, Pid;
	char  callstatus, procname[30], *args[MX_ARGS];
	int   argcount, waitret;

	Pid = atoi(argv[0]);
	strcpy(procname,argv[1]);

	Pread  = atoi(getenv("PREAD"));
	Pwrite = atoi(getenv("PWRITE"));
	Cread  = atoi(getenv("CREAD"));
	Cwrite = atoi(getenv("CWRITE"));

	signal( SIGINT, SIG_IGN	);
	signal( UNBLOCK, unblock);
	
	if( (cfd = fopen( argv[2], "r" )) == NULL ) {
	   fprintf(stderr, "cusnumname: can't open %s\n", argv[2] );
	   exit( 1 );
	   }

	while( fgets( buffer, BUFSIZ, cfd ) != NULL ) {
	   cptr = buffer-1;
	   for( i=0; *(cptr+1) !='\0' && i<2; i++ )
	      cptr = sud( cptr+1, ";\n", fields[i] );
	   number = atoi( fields[0] );
	   if( number < 0 || number > MAX_CUSTS-1 )
	      continue;
	   strcpy( name[number], fields[1] );
	   }

	fclose( cfd );


	/*
	 * wake up parent, initialization is done
	 */
	kill(Pid, UNBLOCK);


	/*
	 * SERVICE LOOP
	 */
	mess[0] = '\0';

	for(;;) {

	   /*
	    * Send response to parent
	    */
	   if( mess[0] != '\0'){
	      write(Cwrite, mess, strlen( mess) +1 );
	      kill( Pid, UNBLOCK);
	      mess[0] = '\0';
	      }

	   pause();

	   argcount = read(Cread, buffer, BUFSIZ);
	   buffer[argcount] = '\0';

	   genparam(args, MX_ARGS, buffer, &argcount);

	   /*
	    * Parameters expected:
	    *    args[0]   Parent Id
	    *    args[1]   call status
	    *    args[2]   proc name
	    *    args[3]   -f
	    *    args[4]   "cusnno=value"
	    *    args[5]   +f
	    *    args[6]   return name
	    */

	   Pid = atoi( args[0] );
	   callstatus = *args[1];

	   /*
	    * No action unless call status is "B" or "M"
	    */
	   if( (callstatus != 'M') && (callstatus != 'B') ) {
	      sprintf(mess,"%s",nothing);
	      continue;
	      }

	   retname[0]    = '\0';
	   fields[0][0]  = '\0';
	   for(i = 3; args[i] != 0 && i <= 6; i++){
	      if( strcmp(args[i], "-f" ) == 0) {

		 /* put value in fields[0] */
		 if( pnvs( args[++i],fields[1], fields[0]) != SUCCESS) {
		    /* parameter error */
		    sprintf(mess, perror, args[i]);
		    continue;
		    }
	         }
	      else if( strcmp( args[i], "+f" ) == 0 ) {
		 strcpy(retname, args[++i]);
		 }
	      else {
		 /* parameter error */
		 sprintf(mess, perror, args[i]);
		 continue;
	         }
	      }
	   if( mess[0] != '\0')
	      continue;

	   /*
	    * If no return name, error
	    */
	   if(retname[0] == '\0') {
	      sprintf(mess, perror, "+f missing");
	      continue;
	      }

	   /*
	    * If no value send back blank
	    */
	   if(fields[0][0] == '\0') {
	      sprintf(mess, blank, retname);
	      continue;
	      }

	   
	   number = atoi( fields[0] );
	   /*
	    * If customer number out of range or no customer
	    *    error
	    */
	   if( (number < 0) || (number > MAX_CUSTS-1) || 
	        (name[number][0] == '\0') ){
	      sprintf(mess, error, retname);
	      continue;
	      }

	   sprintf(mess,"\"\" \"\" +f \"%s=%s\"",retname, name[number]);
	   continue;

	   } /* service loop */
}
