:
# "Erbld.ss",	a shell script to help the user collect personnel
#		directories from around the network

# Copyright 1986 Intel Corporation.

# 04/24/86	dan	Extracted almost in its entirety from oer's Atransa.ss
# 04/25/86	dan	added in gll's suggested improvements
# 05/07/86	oer	add minutes to current time display
# 05/17/86	oer	make wording with Atranss.ss similar
# 06/12/86      gll     Added ILNAP to invocation of Ecollectdir.

$iDISBIN/Fclrscrn

   echo -n "
The time required to collect network personnel directories varies
with the size of the network.  This may be a lengthy process.

This process may be deferred to a later time or done immediately.
In either case, you will be notified by mail when it completes.\n
"

while :
do
   echo -n "
Do you want to defer the rebuilding of the personnel directory?
If so, you will be asked to provide a time at which it should be rebuilt.
If you do not wish to defer, the rebuilding will occur immediately.

(DEL will cancel the operation without rebuilding the personnel directory)

Please enter (y) to defer or (n) to rebuild immediately: "


   read resp
   case $resp in
      y*|Y*) resp=y break ;;
      n*|N*) resp=n break ;;
      *) echo "Invalid response <$resp>, please respecify\n" ;;
   esac
done

$iDISBIN/Fclrscrn

case $resp in
   n)
      # trap hangup, interrupt (delete), and quit
      # (i.e., continue even if user logs off, and don't let him cancel it)
      trap "" 1 2 3

      /iDISboot/Ar $iDISBIN/Ecollectdir "$ILNAP" &

      echo "
The process to collect the personnel directories is processing
in the background.

You will be notified by mail when it has been completed.


"

      exit 0
   ;;

   y)
      # get current day, hour, minute
      set `date '+%w %H %M'`
      day=$1
      ch=`expr $2 + 0`
      cm=`expr $3 + 0`
      echo -n "
To defer the collection of the personnel directories to a later
time, it is necessary for you to supply the hour that this task
is to be started.

This will be a number between 0 and 23.  Where 0 is midnight,
8 is 8am, and 23 is 11pm.

The current time is $cm minutes past hour  $ch.  If the hour you
supply is less than or equal to  $ch , the transactions will be
scheduled for tomorrow at that time.

(DEL will cancel the operation without rebuilding the personnel directory)

"
      while :
      do
	 echo -n "
Please enter the hour this task is to start (a number between 0 and 23): "

	 read oresp
	 # only allow numbers and letters
	 resp=`echo $oresp|tr -d "[\001-\057][\072-\100][\133-\140][\173-\177]"`
	 if echo $resp | egrep '[^0-9]' > /dev/null ; then
	    echo "Invalid response <$oresp>, please respecify\n"
	 elif [ -z "$resp" -o "$resp" -lt 0 -o "$resp" -gt 23 ] ; then
	    echo "Invalid response <$oresp>, please respecify\n"
	 else
	    break
	 fi
      done
      hour=$resp

      # trap hangup, interrupt (delete), and quit
      # (i.e., continue even if user logs off, and don't let him cancel it)
      trap "" 1 2 3

      # handle those for tomorrow
      if [ $hour -le $ch ] ; then
	 case $day in
	    0) day=Monday ;;
	    1) day=Tuesday ;;
	    2) day=Wednesday ;;
	    3) day=Thursday ;;
	    4) day=Friday ;;
	    5) day=Saturday ;;
	    6) day=Sunday ;;
	 esac
	 which=tomorrow
      else
	 day=""
	 which=today
      fi

      $iDISBIN/Fclrscrn

      echo "One moment please ..."


      echo "# Scheduled collection of personnel directories.
LOGINID=$LOGINID; export LOGINID
MASNODEP=$MASNODEP; export MASNODEP
ILNAP=$ILNAP; export ILNAP
/iDISboot/Ar $iDISBIN/Ecollectdir \"$ILNAP\"
" > /tmp/Ecollect$$

      at $hour $day /tmp/Ecollect$$

      rm /tmp/Ecollect$$

      $iDISBIN/Fclrscrn
   
      echo "
The process to collect the personnel directories has been scheduled
to begin at hour $hour ${which}.

You will be notified by mail when it has been completed.


"

      exit 0
   ;;
esac
