:
# "Axnodes.ss", a shell script to get list of this Sub-Network's XENIX nodes
#               (standalone systems return just their own name)

# Copyright 1986 Intel Corporation.

# 05/29/86  oer  Exclude Public Server nodes, unless a -p flag given.
# 06/05/86  gll  Modified to exclude both public nodes and other
#                sub-net masters.  If -p given, ALL XENIX nodes returned.
# 06/25/86  oer  Ensure no duplicates exist (why they should is a mystery).
# 06/27/86  gll  Modified to include just the public nodes if -p given,
#                not all nodes.

case $OPENNET in
   n) exec echo $PHYSYS ;;
   y)
	     trap "rm -rf /usr/tmp/Axn$$ /usr/tmp/Axn1$$ \
                  ; trap 0; exit 0" 0 1 2 3 15

             if [ "$1" = "-p" ]
             then : continue
             else # Discard Public Servers
                  $iDISBIN/Uselect -s : 0 1 "Public Server" \
                       < $MASNODEP/etc/drm/subnet > /usr/tmp/Axn$$
             fi

             # Discard other Sub-Network Masters
             $iDISBIN/Uselect -s : 0 1 "Sub-Network" \
                  < $MASNODEP/etc/drm/subnet >> /usr/tmp/Axn$$

             # I said "other" Sub-Network masters, keep local master.
             sed -e "/$MASNODE/d" /usr/tmp/Axn$$ | sort -u > /usr/tmp/Axn1$$

             # Now get list of all XENIX nodes, and return all but
             # but discards figured out above.
             exec sed -n -e 's/^\(.*\)\/nfs:TYPE=XENIX.*$/\1/p' /net/data \
                  | sort -u | comm -23 - /usr/tmp/Axn1$$
   ;;
esac
