: 'Copyright 1986 Intel Corp.'
# Auserxd.ss, build raw transaction for "Delete User"

Ausr=$1 export Ausr

if [ -f $MASNODEP/etc/passwd ] ; then :
else
   echo The master password file on node $MASNODE could not be accessed.
   echo You must try again later when connection is established.
   exit 1
fi

if egrep \^$Ausr: $MASNODEP/etc/passwd > /dev/null 2>&1 ; then : 
else
   echo Login ID $Ausr does not exist in the master password file.
   echo Deletion process for Login ID $Ausr has been canceled.
   exit 1
fi

# The following code added for patchkit 2.0  ...  ajw
# Only allows delete if HOME starts "/usr..."  or "//<node>/usr..."
# and the next component of path is not in the list below.
# Sets the Home File System, from HOME
# HOME=//node/filesystem/loginid  or  /filesystem/loginid
set `Uselect -s : 5 0 $Ausr <$MASNODEP/etc/passwd`
dir=$1		# guard against duplicates
case -$dir in
	-) ;;
	-//*)	nextcomp=`echo $dir | Uselect -es / 4 3 '^usr'`
		HomeFS=`dirname \`expr $dir : "//.*/\(.*/.*\)"\``
	;;
	-*)	nextcomp=`echo $dir | Uselect -es / 2 1 '^usr'`
		HomeFS=`dirname \`expr $dir : "/\(.*/.*\)"\``
	;;
esac
case -$nextcomp in
	-|-iDIS|-spool|-rje|-idis)
		echo The Login ID \"$Ausr\" may not be deleted,
		echo it does not represent an ordinary user.
		exit 1
esac

while :
do
   echo "Confirm that you wish to delete the files of Login ID $Ausr"
   echo -n "Enter (y or n) "
   read resp
   case $resp in
      y*|Y*)	break ;;
      n*|N*)	echo Deletion process for Login ID $Ausr has been canceled.
		exit 1 ;;
      *)	echo "Invalid response <$resp>, please respecify\n" ;;
   esac
done

# Remove any resource assignments for this user
# Need to get exclusive access to the file first, see Arassgn.mac
if [ -f $MASNODEP/etc/drm/finder.awork.t ] ; then
   cat <<-HERE
	
	The resource assignment file is currently being updated by another user.
	Please try your deletion request again in a few minutes.  Thank you.
	HERE
   exit 0
fi
ln $MASNODEP/dev/null $MASNODEP/etc/drm/finder.awork.t  2>/dev/null
case $? in
   0)
      sed -e '/^[^:]*:[^:]*:'$Ausr':/d' \
         $MASNODEP/etc/drm/finder.assign > /tmp/Axfa$$
      mv /tmp/Axfa$$ $MASNODEP/etc/drm/finder.assign
      chmod 666 $MASNODEP/etc/drm/finder.assign
      rm -f $MASNODEP/etc/drm/finder.awork.t
   ;;
   *) cat <<-HERE
	
	The resource assignment file is currently being updated by another user.
	Please try your deletion request again in a few minutes.  Thank you.
	HERE
      exit 0
   ;;
esac

# Remove the user from the master passwd file
/iDISboot/Ar /iDISboot/AUpw.ss RESTART

# build the raw transaction file, signal pending
>   /usr/tmp/$LOGINID.idisP
RAW=/usr/tmp/$LOGINID.idisU
cat <<-HERE >> $RAW
	#( Delete user $Ausr
	Kind=user
	Ttype=Xdel
	OPENNET="$OPENNET"
	MASNODE="$MASNODE"
	MASNODEP="$MASNODEP"
	Ausr="$Ausr"
	HomeFS="$HomeFS"
	export Kind Ttype OPENNET MASNODE MASNODEP Ausr HomeFS
	#) Delete user $Ausr
HERE

exit 0
