: 'Copyright 1986 Intel Corp.'
# Print the specifications of the templates

cd $MASNODEP/etc/Templates

for template in `ls`
do
   cd $MASNODEP/etc/Templates/$template
   [ -s comments ] &&
       pr -h "<<  Template=$template,  Comment file  >>" comments
   set `$iDISBIN/Atemplms.ss $template`
   lshell=$1 lo=$2 mshell=$3 mo=$4
   {  echo "                        Login shell:  $lshell"
      case $lo in
         no) lo= ;;
      esac
      echo "\nPath specification of 'other_shell':  $lo"

      echo "\n\n              Menu system sub-shell:  $mshell"
      case $mo in
         no) mo= ;;
      esac
      echo "\nPath specification of 'other_shell':  $mo"
   } | pr -h "<<  Template=$template,  Login shell, Menu system sub-shell  >>"
   [ -s profile ] &&
      pr -h "<<  Template=$template,  XENIX shell 'login' commands  >>" profile
   [ -s mailrc ] &&
      pr -h "<<  Template=$template,  Initial mail commands  >>" mailrc
   [ -s cshrc ] &&
      pr -h "<<  Template=$template,  C shell 'start' commands  >>" cshrc
   [ -s login ] &&
      pr -h "<<  Template=$template,  C shell 'login' commands  >>" login
   [ -s finder.cur ] &&
      pr -h "<<  Template=$template,  'current resource' file  >>" finder.cur
   if [ -s finder.assign ] ; then
      awk -F\: \
      '{printf "Resource name:  %-14s\n", $1
	printf "Type:           %-14s\n", $2
	printf "Login ID:       loginID\n"
	printf "Priority:       %-3s\n",  $4
	printf "Comment:	%-60s\n\n\n", $5
      }' finder.assign
   fi | pr -h "<<  Template=$template Resource assignments  >>" 2>/dev/null
   set `$iDISBIN/Atemplme.ss $template`
   ied=$1 med=$2
   case $ied in
      not_allowed) ;;
      *) echo "iDIS file editor:         $ied\n\n"
	 echo "Menu development editor:  $med"
   esac | pr -h "<<  Template=$template iDIS file/Menu Development editors  >>" 2>/dev/null

   for menusystem in `ls menusystems`
   do
      cd $MASNODEP/etc/Templates/$template/menusystems/$menusystem
      [ -s login.pro ] &&
	 pr -h "<<  Template=$template, menusystem=$menusystem, login profile  >>" login.pro
      if [ -s login.dat ] ; then
	 ORIGIFS=$IFS
	 IFS=';	 '
	 set `cat login.dat`
	 IFS=$ORIGIFS
	 pinnacle=$4
	 os=$5
	 site=$6
	 echo "User's pinnacle, or starting, menu:  $pinnacle\n"
	 echo "Allow user to enter the Operating System (y or n):  $os\n"
	 echo "Allow user to access the (site) menu (y or n):      $site"
      fi | pr -h "<<  Template=$template, menusystem=$menusystem, login file  >>" 2>/dev/null
      if [ -s deauth.dat ] ; then
	 sort deauth.dat |
	 awk -F\; '{printf "Menu name:  %-10s\tMenu selection:  %-10s\n\n",$2,$3}'
      fi | pr -h "<<  Template=$template, menusystem=$menusystem, Deauthorizations  >>" 2>/dev/null
      [ -s path ] &&
	 pr -h "<<  Template=$template, menusystem=$menusystem, Path to menu system home directory  >>" path

   done

done
