:   Copyright 1986 Intel Corporation
#
#   Install a feature on a remote node.
#
#   param 1 -- fb directory 
#   param 2 -- node name to be installed
#   param 3 -- feature name to be installed
#
# 05/13/86  rhc add PATH for Ar usage

PATH=/bin:/usr/bin	export PATH
fb=$1
d_node=$2
feature=$3
idis=`$iDISBIN/Unonode $iDIS`
idisbin=`$iDISBIN/Unonode $iDISBIN`
#
if [ ! -d //$d_node$idis ] ; then
  echo "
        The iDIS software is not installed on $d_node node.
	You can not install $feature feature on $d_node node.

	You may have made an error in specifying the iDIS resources.
        Please check your resource specifications.
      "
  echo
  echo -n "Please press RETURN to continue: "
  read ABC
  exit 0
fi
#
#  First make sure that feature installation/deletion is going on.
#   Check whether $idis/fb_lock is locked.
#
$iDISBIN/Flock -x //$d_node$idis/fb_lock -e sleep 0
if [ $? != 0 ] ; then
   echo
   echo "   Feature installation/deletion is currently under progress on"
   echo "     node $d_node. Please try later."
   echo
   echo -n "Please press RETURN to continue: "
   read ABC
   exit 0
fi
#
# copy the feature software in to a temporary directory on
#  the remote system.
#
echo
echo
echo -n "Copying $feature feature software to node $d_node ..."
copy -rmf $fb //$d_node$idis/fb
# 
# check whether copy was successful
if [ $? != 0 ] ; then
  echo " "
  echo "Copy failed."
  exit 1
fi
# 
echo
echo
echo "Copy complete."
echo
echo -n "Starting installation of $feature on node $d_node ..."
#
ttydev=`net name``tty`
#
#  Determine whether we have to run feature install in interactive mode
count=`grep -c "^$feature" $iDIS/fb_interactive`
if [ $count -gt 0 ] ; then
  interactive=y
  outdev=$ttydev
else
  interactive=n
  outdev=/dev/null
fi
#
remotescript=//$d_node/tmp/$d_node$$
#
#  Now, create the remote script(self-contained) on destination system to 
#    perform feature installation on destination system
#   
cat > $remotescript <<-HERE
:  # force in to bourne shell.
PATH=/bin:/etc:/usr/bin/.
export PATH
trap "rm -f $remotescript;exit" 0 3 15
(
fbtty=$ttydev
iDISBIN=$idisbin
iDIS=$idis
export iDISBIN iDIS fbtty
#
# ignore quit signal
trap "" 1 2 3 15
#
#  initiate feature install
#
\$iDISBIN/fb $ttydev
#
#   See whether there are any errors
#
if [ $? != 0 ] ; then   # fb could not install
   fb_err=1
elif [ -f \$iDIS/report ] ; then
   count=\`grep -c "^[^> ]" \$iDIS/report\`
   if [ \$count -gt 0 ] ; then
      errors=
   else
      errors="NO "
  fi
fi
#
#   Feature installation is complete on remote system. Now append the
#    the latest activity log to the zaplog file for future reference.
#
echo "          iDIS SOFTWARE FEATURE INSTALLATION of $feature feature " >> \$iDIS/zaplog
echo "            on `date`" >> \$iDIS/zaplog
echo " " >> \$iDIS/zaplog
cat \$iDIS/report >> \$iDIS/zaplog
echo " " >> \$iDIS/zaplog
#
#  Next insert the message as how to look for errors in report file.
#
cd \$iDIS
echo "NOTE: Please look for lines that start in column 1" > report.tmp1
echo " (but not with a '>' character) to identify errors, if any." >> report.tmp1
echo " " >> report.tmp1
cat report >> report.tmp1
rm report
mv report.tmp1 report
# 
chown iDIS report debug
chmod 444 report debug
#
#   Now that we are done with the entire feature installation process,
#    we need to send mail to the person who initiated the feature 
#    installation.
#
if [ "\$fb_err" = "1" ] ; then
    mail -s "Installation of $feature feature on node $d_node" `logname` > /dev/null <<!
The $feature feature was not installed on node $d_node. 
For more details, please check the report file by selecting 
'view' selection on 'Afinst' menu.
!
else
    mail -s "Installation of $feature feature on node $d_node" `logname` > /dev/null <<!
The installation of the $feature feature on the node $d_node is complete. 
There were \${errors}errors during the $feature feature installation. 
For more details, please check the report file by selecting 
'view' selection on 'Afinst' menu.
!
fi
#
if [ "\$fb_err" = "1" ] ; then
  echo "
  The $feature feature was not installed.
  The installation procedure for $feature feature was missing.
  For more details, please check the report file by selecting  
  'view' selection on 'Afinst' menu.
  "  | tee -a report | tee -a zaplog
elif [ "\$errors" = "NO " ] ; then
  echo "
  The $feature feature installation is successful.
  Please logout and login again to use $feature feature.
  "  | tee -a report | tee -a zaplog
else
  echo "
  Errors were encountered during the $feature feature installation.
  For more details, please check the report file by selecting  
  'view' selection on 'Afinst' menu.
  "  | tee -a report | tee -a zaplog
fi
#
echo "/* ----------------------------------------------------------------- */"\
      >> zaplog
echo " " >> zaplog
#
) > $outdev 
# 
HERE
#
chmod 700 $remotescript
#
# Tell the user to hang around, if necessary.
if [ "$interactive" = "y" ] ; then
  echo
  echo " 
 NOTE:  During the installation of $feature feature on node $d_node,
        you will be asked to respond to certain questions. You MUST
        respond to those questions within ONE MINUTE. Otherwise, it 
	will result in improper installation."
fi
#  All the preparatory work is done. 
#  Initiate the installation on the destination node
#
rexec //$d_node$idisbin/Flock -x //$d_node$idis/fb_lock -e $remotescript -- /dev/null
#
#  feature installation has been started on the remote system.
#
if [ "$interactive" = "n" ] ; then
   echo " "
   echo " "
   echo "Feature installation is in progress on node $d_node."
   echo "Mail will be sent to you as soon as the installation is complete."
   #
else
   #  Feature install may expect some user interaction, so we must lock
   #    the terminal
   #
   while [ -f $remotescript ]
     do
       sleep 3
     done
fi
#
echo
echo -n "Please press RETURN to continue: "
read ABC
#
