# "Apubi.ss", a shell script to build raw transaction for 
#     "Initialize Public workarea"

# Copyright 1986 Intel Corporation.

# 04/09/86  ugg  Initial entry for iDIS R2.0.
# 06/12/86  ugg  validate the home filesystem.
#
# ignore the quit signals
trap "" 1 2 3 15
#

# First, gather up the parameters passed to us on the command line.

Apub=$1		shift  # Public workarea name
comment="$1"	shift  # description

HomeNode=$1	shift  # Home node to make workarea on
HomeFS=$1	       # File System on Home node to use

Grouptype=iDISPUBLIC

Agid=800	       # Public workareas are owned by iDIS 

Lshell="\"\""	       # This is not really a valid login

#  First make sure the $HomeFS filesystem is valid.

if [ "$OPENNET" = "y" ] ; then
   node=$HomeNode
   reference="the node $node"
   pattern=":file-system:$node:"
   command="$iDISBIN/Uselect -s : 3 2 $node"
   sedpat="$pattern"
   field=2
else
   node=
   reference="this system"
   pattern=":file-system:"
   command="$iDISBIN/Uselect -s : 3"
   sedpat="$pattern\([^:]*\):"
   field=3
fi

if [ `grep ":file-system:" $MASNODEP/etc/drm/finder.rsrc | $command | grep -c "/dev/$HomeFS$" ` = 0 ] ; then
   
     echo " 
The $HomeFS filesystem on $reference is not specified as a resource.
If the $HomeFS filesystem is present on $reference, you need to specify 
it as a 'file-system' type resource before you can define the 
public workarea's home on $HomeFS filesystem.
	"

     if egrep "$pattern" $MASNODEP/etc/drm/finder.rsrc >/dev/null ; then 
        echo "
The following filesystem(s) are currently defined on $reference:
	"

        sed -n -e 's/^\([^:]*\)'$sedpat'\/dev\/\([^:]*\):.*$/'\\$field'/p' $MASNODEP/etc/drm/finder.rsrc | sort | pr -5 -w79 -t
     else
        echo "
No filesystems for $reference are specified in the iDIS resource 
specifications.
	"
     fi

     exit 1
fi

case $OPENNET in y) Home=//$HomeNode/$HomeFS/$Apub ;;
                 *) Home=/$HomeFS/$Apub ;;
esac

# ensure that this public workarea as a user is unique
#  in the master password file.

/iDISboot/Ar $iDISBIN/Aaddpwnc $MASNODEP/etc/passwd 0 $Apub \"$Grouptype\" 800 $Agid \"$comment\" $Home $Lshell > /tmp/Aadd$$
rtn=$?
Auid=`cat /tmp/Aadd$$`; rm -f /tmp/Aadd$$
case $rtn in
	0) ;;
	1) echo "There is an entry in the password file with $Apub as its Login ID.\n"
	   egrep \^$Apub $MASNODEP/etc/passwd
	   echo "\nYou must specify a public workarea name that is unique."
	   echo "This initialization has been rejected."
	   exit 1 ;;
	2) echo "There is another user with the $Auid User ID number.\n"
	   $iDISBIN/Uselect -s \: 0+ 2 $Auid < $MASNODEP/etc/passwd
	   echo "\nYou must choose one that is unique."
	   echo "This initialization has been rejected."
	   exit 1 ;;
	3) echo The master password file on node $MASNODE could not be accessed.
	   echo You must try again later when connection is established
	   exit 1 ;;
	4) echo "The Login ID you supplied ($Apub) has an invalid format."
	   echo "The Login ID must be at least 3 characters, beginning with a letter."
	   echo "This initialization has been rejected."
	   exit 1 ;;
	5) echo "The User ID number you supplied, $Auid, is not legal."
	   # ACTUALLY 65535 IS ALSO LEGAL, FOR RMX OPENNET
	   echo "The number must be within 0 to 32767."
	   echo "This initialization has been rejected."
	   exit 1 ;;
	6) echo "There are no more User ID numbers available on this system."
	   echo "Please call your Intel support personnel for instructions."
	   echo "This initialization has been rejected."
	   exit 1 ;;
esac

# Build the raw transaction file, signal pending
>   /usr/tmp/$LOGINID.idisP
RAW=/usr/tmp/$LOGINID.idisW
cat <<-HERE >> $RAW
	#( Initialize public workarea $Apub
	Ttype=Init
	Kind=group
	OPENNET="$OPENNET"
	MASNODE="$MASNODE"
	MASNODEP="$MASNODEP"
	Ausr="$Apub"
	Auid="800"
	Amgr=""
	Aepw="$Grouptype"
	HomeNode="$HomeNode"
	HomeFS="$HomeFS"
	FirstN="$comment"
	MiddleN=""
	LastN=""
	Ophone=""
	Oloc=""
	Oinfo=""
	Oinfo2=""
	Gid="$Agid"
	Home="$Home"
	Lshell=""
	export Ttype Kind OPENNET MASNODE MASNODEP Ausr Auid Amgr Grouptype 
	export MiddleN LastN Ophone Oloc Oinfo Oinfo2 Gid Home HomeFS FirstN
	export HomeNode Aepw Lshell
	#) Initialize public workarea $Agrp
HERE

exit 0
