: 'Copyright 1986 Intel Corp.'
printcapname=$1
shift
case $# in
  1)
    nodename=$1 ;;
  2)
    nodename=$1
    log=$2 ;;
  *)
    cat <<-\HERE
	rlpq: (remote "lpq") reports the content of a printer queue on
	a remote node.
	usage: rlpq <remote_node> [<log_file>]
	    <remote_node> is name of node where "lpq" will
	       be executed.
	    <log_file> is fully qualified path for standard output
	       (including node name).  If <log_file> does not
	       include the node name, it will be relative to
	       <remote_node>.  if <log_file> is omitted, standard
	       output will be returned to your terminal.
	       Note - output is appended to <log_file>.
	HERE
    exit 1
    ;;
esac

netdelm=`net delimiter`
locnode=`net name`
ORIGIFS=$IFS
IFS=$netdelm
set `net name`
locnodename=$1
IFS=$ORIGIFS
case $log in
  "")	# no log specified, send stdout/stderr back to this terminal
    ttydev=`tty`
    outdev=$locnode$ttydev ;;
  *)	# send stdout, stderr to log_file only
    outdev=$log ;;
esac
if [ ! -f $netdelm$nodename/net/self ]
  then
    echo "Node $nodename not accessible." >>$outdev 
    exit 1
fi

remotescript=$netdelm$nodename/tmp/$locnodename$$
cat >$remotescript <<-HERE
	: #	(place commands to be executed on remote node below # # # # #)
	#   	(\$1 is node name, \$2 is path to send stdout/stderr)
	PATH="/bin:/usr/bin:."
	trap "rm -f $remotescript; trap 0; exit" 0 1 2 3 15
	#							***
	/iDISboot/Ar /bin/lpq -P$printcapname >>\$2 2>&1
	#							***
	# 	(end of commands to be executed on remote node      # # # # #)
HERE
chmod 0700  $remotescript

case $locnodename in
  $nodename)
    $remotescript $nodename $outdev ;;
  *)
    rexec  $remotescript $nodename $outdev -- /dev/null
    while  [ -f $remotescript ]
      do
	sleep 3 #  wait for remote shell script to finish
      done
esac
