: 'writes a forms alignment pattern to the printer'
# Copyright 1986 Intel Corporation.
P=$1
echo PRINTER FORM ALIGNMENT
echo
R=`Uselect -es : 3 0 $P</etc/drm/finder.rsrc`
if [ "$OPENNET" = "y" ]; then
	NODE=`Uselect -es : 2 0 $P</etc/drm/finder.rsrc`
	S=`Aprintcap sd $R $NODE`
	if [ ! -f //$NODE$S/lock -o -s //$NODE$S/lock ]; then
		echo "Please halt the printer before performing forms alignment."
		exit 1
	fi
	PORT=//$NODE`Aprintcap lp $R $NODE`
else	
	S=`Aprintcap sd $R`
	if [ ! -f $S/lock -o -s $S/lock ]; then
		echo "Please halt the printer before performing forms alignment."
		exit 1
	fi
	PORT=`Aprintcap lp $R`
fi

echo
echo -n "How many characters wide? "
read w
again="yes"
until [ "$again" = "no" ] 
do
	while [ $w -gt 132 -o $w -le 0 ]
	do
		echo -n "please specify a width between 1 and 132. "
		read w
	done
	Apform $w >$PORT
	echo
	echo -n "again? (y,n) "
	read r
	if [ "$r" != "y" ]; then
		again="no"
	fi
done
if [ "$OPENNET" = "y" ]; then
	FORMFEED=`Aprintcap ff $R $NODE 2>/dev/null`
	PORT=//$NODE`Aprintcap lp $R $NODE`
	if [ "$FORMFEED" = "" ]; then
		FORMFEED='\f'
	fi
	sleep 3
	echo $FORMFEED >$PORT
else
	FORMFEED=`Aprintcap ff $R 2>/dev/null`
	PORT=`Aprintcap lp $R`
	if [ "$FORMFEED" = "" ]; then
		FORMFEED='\f'
	fi
	sleep 3
	echo $FORMFEED >$PORT
fi
