: 'Copyright 1983, 1986 Intel Corp.'
# Ap.ss
# add the PUBLIC domain to the system, uses gid == uid == 810
# oer	12/4/85  change name to 'public'
# ugg   02/03/86 Added iASWBASE directories
# ugg   02/24/86 Add the idis_dir name to the file_db.
# ugg   02/24/86 Add idis_dir and rje_dir directory structures to the
#                user "public".
# ugg   03/03/86 Corrected a mistake in adding directory names to file
#		 database( use /usr instead of $usr, which is undefined)
# gll   03/26/86 Corrected for iDIS R2.0 public workarea formats.
# oer	07/14/86 Change name of Lyrix directory

# Be certain Aiu.ss (initialize a user) also gets
# changed when Ap.ss is changed

name=public
shell="Not a valid login"
if grep -s \^$name: /etc/passwd > /dev/null
	then echo Ap.ss: $name already exists in "/etc/passwd"
	     exit 1
fi

# create a unique user and group id
uid=${uid:=`$iDISBIN/uid 100`}
gid=$uid
echo $name:iDISPUBLIC:$uid:$gid::/usr/$name:$shell >> /etc/passwd

# "set umask so that the files are PUBLIC"
umask 0

# create home directory 
cd /usr
mkdir $name
chown 800 $name; chgrp $gid $name
cd $name

# make the idis and rje directories,
# make the calendar file which is read-only

echo "This is the PUBLIC calendar" >> calendar
echo "It cannot be modified by iDIS users." >> calendar
chmod 444 calendar

mkdir idis_dir
# set the owner and group ids for the files in the HOME directory
chown 800 idis_dir calendar
chgrp 800 idis_dir calendar
$iDISBIN/file_db -a /usr/$name/idis_dir

mkdir idis_dir/db_dir
chown 800 idis_dir/db_dir
chgrp 800 idis_dir/db_dir
$iDISBIN/file_db -a /usr/$name/idis_dir/db_dir

mkdir idis_dir/hj_dir
chown 800 idis_dir/hj_dir
chgrp 800 idis_dir/hj_dir
$iDISBIN/file_db -a /usr/$name/idis_dir/hj_dir

mkdir idis_dir/hs_dir
chown 800 idis_dir/hs_dir
chgrp 800 idis_dir/hs_dir
$iDISBIN/file_db -a /usr/$name/idis_dir/hs_dir

mkdir idis_dir/ss_dir
chown 800 idis_dir/ss_dir
chgrp 800 idis_dir/ss_dir
$iDISBIN/file_db -a /usr/$name/idis_dir/ss_dir

mkdir idis_dir/ss_dir/.mdl_dir
chown 800 idis_dir/ss_dir/.mdl_dir
chgrp 800 idis_dir/ss_dir/.mdl_dir
$iDISBIN/file_db -a /usr/$name/idis_dir/ss_dir/.mdl_dir

mkdir idis_dir/wp_dir
chown 800 idis_dir/wp_dir
chgrp 800 idis_dir/wp_dir
$iDISBIN/file_db -a /usr/$name/idis_dir/wp_dir

mkdir idis_dir/xl_dir
chown 800 idis_dir/xl_dir
chgrp 800 idis_dir/xl_dir
$iDISBIN/file_db -a /usr/$name/idis_dir/xl_dir

mkdir idis_dir/xn_dir
chown 800 idis_dir/xn_dir
chgrp 800 idis_dir/xn_dir
$iDISBIN/file_db -a /usr/$name/idis_dir/xn_dir

# make the rje directories

mkdir rje_dir
chown 800 rje_dir
chgrp 800 rje_dir
$iDISBIN/file_db -a /usr/$name/rje_dir

mkdir rje_dir/ho_dir
chown 800 rje_dir/ho_dir
chgrp 800 rje_dir/ho_dir
$iDISBIN/file_db -a /usr/$name/rje_dir/ho_dir

mkdir rje_dir/xd_dir
chown 800 rje_dir/xd_dir
chgrp 800 rje_dir/xd_dir
$iDISBIN/file_db -a /usr/$name/rje_dir/xd_dir

mkdir rje_dir/xs_dir
chown 800 rje_dir/xs_dir
chgrp 800 rje_dir/xs_dir
$iDISBIN/file_db -a /usr/$name/rje_dir/xs_dir

# make the iASWBASE directories

mkdir asw_dir
chown 800 asw_dir
chgrp 800 asw_dir
chmod 777 asw_dir
$iDISBIN/file_db -a /usr/$name/asw_dir

mkdir asw_dir/ghop_dir
chown 800 asw_dir/ghop_dir
chgrp 800 asw_dir/ghop_dir
chmod 777 asw_dir/ghop_dir
$iDISBIN/file_db -a /usr/$name/asw_dir/ghop_dir

mkdir asw_dir/htbg_dir
chown 800 asw_dir/htbg_dir
chgrp 800 asw_dir/htbg_dir
chmod 777 asw_dir/htbg_dir
$iDISBIN/file_db -a /usr/$name/asw_dir/htbg_dir

mkdir asw_dir/lyrx_dir
chown 800 asw_dir/lyrx_dir
chgrp 800 asw_dir/lyrx_dir
chmod 777 asw_dir/lyrx_dir
$iDISBIN/file_db -a /usr/$name/asw_dir/lyrx_dir

mkdir asw_dir/mcba_dir
chown 800 asw_dir/mcba_dir
chgrp 800 asw_dir/mcba_dir
chmod 777 asw_dir/mcba_dir
$iDISBIN/file_db -a /usr/$name/asw_dir/mcba_dir

mkdir asw_dir/pbg_dir
chown 800 asw_dir/pbg_dir
chgrp 800 asw_dir/pbg_dir
chmod 777 asw_dir/pbg_dir
$iDISBIN/file_db -a /usr/$name/asw_dir/pbg_dir

mkdir asw_dir/cmst_dir
chown 800 asw_dir/cmst_dir
chgrp 800 asw_dir/cmst_dir
chmod 777 asw_dir/cmst_dir
$iDISBIN/file_db -a /usr/$name/asw_dir/cmst_dir

mkdir asw_dir/Qoff_dir
chown 800 asw_dir/Qoff_dir
chgrp 800 asw_dir/Qoff_dir
chmod 777 asw_dir/Qoff_dir
$iDISBIN/file_db -a /usr/$name/asw_dir/Qoff_dir

mkdir asw_dir/rds_dir
chown 800 asw_dir/rds_dir
chgrp 800 asw_dir/rds_dir
chmod 777 asw_dir/rds_dir
$iDISBIN/file_db -a /usr/$name/asw_dir/rds_dir

mkdir asw_dir/traj_dir
chown 800 asw_dir/traj_dir
chgrp 800 asw_dir/traj_dir
chmod 777 asw_dir/traj_dir
$iDISBIN/file_db -a /usr/$name/asw_dir/traj_dir

