: Copyright 1986 Intel Corporation
#
#  Delete a list of members from a group in the master /etc/group file
# 05/13/86  rhc add PATH for Ar usage

PATH=/bin:/usr/bin	export PATH
#
# ignore quit signal 
trap "" 1 2 3 15
#
group=$1
shift
#
error=no
#
#  Make sure that the specified login ids exist as members of the group
#
egrep "^$group:" $MASNODEP/etc/group > /tmp/Amgml$$
for name in $*
  do
     if egrep "$name," /tmp/Amgml$$ >/dev/null 2>/dev/null ; then
        :
     else
        error=yes
        echo
        echo "          Login id $name is not a member of group $group."
     fi
  done
rm -f /tmp/Amgml$$

#
#   if there were any errors, exit without doing anything
#
if [ "$error" = "yes" ] ; then
     echo "
          The specified login ids were not deleted from group $group.
          Please correct the reported errors, and re-specify."
     exit 1
fi

for name in $*
  do
     sed -e "s/^\($group::[^:]*:.*\)\($name,\)\(.*\)$/\1\3/" \
	 -e "s/^\($group::[^:]*:.*\)\($name\)\(.*\)$/\1\3/" $MASNODEP/etc/group > /tmp/group.tmp

     copy -o /tmp/group.tmp $MASNODEP/etc/group$$
     mv $MASNODEP/etc/group$$ $MASNODEP/etc/group
  done
#
#  Update the mailrc aliases
for name in $*
  do
     sed -e "s/^\(alias $group .*\)\( $name\)\(.*\)$/\1\3/" $MASNODEP/usr/lib/mail/mailrc > /tmp/mail.tmp

     copy -o /tmp/mail.tmp $MASNODEP/usr/lib/mail/mailrc$$
     mv $MASNODEP/usr/lib/mail/mailrc$$ $MASNODEP/usr/lib/mail/mailrc
  done

#   make sure the access rights are set right
chmod 664 $MASNODEP/etc/group
chmod 664 $MASNODEP/usr/lib/mail/mailrc

#  Next create a transaction, if necessary, to propagate the master group file.

if [ -f /usr/tmp/$LOGINID.idisW ] ; then
   count=`grep -c "Modify membership list" /usr/tmp/$LOGINID.idisW`
else
  count=0
fi

if [ $count = 0 ] ; then

   # Build the raw transaction file, signal pending
   >   /usr/tmp/$LOGINID.idisP
   chmod 666 /usr/tmp/$LOGINID.idisP
   RAW=/usr/tmp/$LOGINID.idisW
   cat <<-HERE >> $RAW
	#( Modify membership list for $group
	Ttype=Mod
	Kind=group 
	OPENNET="$OPENNET"
	MASNODE="$MASNODE"
	MASNODEP="$MASNODEP"
	Aepw="GROUP"
	HomeNode="$HOMENODE"
	export Ttype Kind OPENNET MASNODE MASNODEP Aepw HomeNode
	#) Modify membership list
	HERE
   chmod 666 $RAW
fi
exit 0
