:
# "Alnaupd.ss", a shell script to update network configuration files
#               on the Sub-Network master nodes.

# Copyright 1986 Intel Corporation.

# 05/21/86  gll  Written for iDIS R2.0.
# 07/29/86  gll  Changed message mailed to ilna upon successful 
#                completion.

# The 'ilna' password must be passed as the first parameter.

if [ $# -lt 1 ]
then mail -s "Update of Sub-Network Master Nodes" ilna <<HERE 2>&1
The 'ilna' password was not provided for this operation.
The connection to the Sub-Network master nodes cannot be
established, and the network configuration files cannot be
updated.

The updates have been retained, and will be performed when you
make the 'upd - Update Sub-Network master nodes' selection from
the Alnatop menu again.
HERE
     exit 1
fi

ilnap=$1

# Do this once for each Sub-Network Master node.

save=$MASNODEP/usr/ilna/netsynch            # In case of errors
source=$MASNODEP/usr/ilna/netsynch/pending  # Where to get updates from

for master in `$iDISBIN/Uselect -s : 0 1 Sub-Network < $MASNODEP/etc/drm/subnet`
do
   # Assume it will work until it doesnt

   rtncode=0

   # Attempt to connect to the Sub-Network master node

   $iDISBIN/Aconnect.ss -l ilna -p "$ILNAP" $master

   # If connection fails, then save the updates for this Sub-Network
   # for later retries, and inform ilna.

   if [ $? -ne 0 ]
   then # Create the save area, if necessary
        if [ ! -d $save/$master ]
        then mkdir $save/$master
             chmod 770 $save/$master
             chgrp 800 $save/$master
             chown 800 $save/$master
        fi

        # Now point to the save area to complete this operation.

        target=$save/$master

        # Inform ilna of the failure.

        rtncode=1

   else # Point to the target area on the Sub-Network master node
        target=//$master/usr/ilna/netsynch/applied
   fi

   # Target area established, now see if the files it contains are
   # being used.

   retry=0
   while [ -f $target/ilnaWIP -a $retry -lt 10 ]
   do
      # The current Sub-Network master node is busy updating
      # the network configuration files right now.  Wait for
      # 1 minute, then retry.  Do this for 10 minutes, then give up.

      sleep 60
      retry=`expr $retry + 1`
      
      if [ $retry -ge 10 ]
      then # Create the save area, if necessary
           if [ ! -d $save/$master ]
           then mkdir $save/$master
                chmod 770 $save/$master
                chgrp 800 $save/$master
                chown 800 $save/$master
           fi

           # Now point to the save area to complete this operation.
   
           target=$save/$master

           # Inform ilna of the failure.

           rtncode=3
      fi
   done

   # if updates are already pending, then remove the pending flag
   # in case the Sub-Network master fires off AUsynch.ss while
   # we are updating.

   if [ -f $target/ilnaP ]
   then rm -f $target/ilnaP
   fi

   # Now proceed to move all known updates for this Sub-network master
   # into the target area.

   for file in `lc $source`
   do 
      case $file in newdata) # New entries for /net/data

                             # First, pick up entries saved from previous
                             # attempts to update this Sub-Network

                             if [ "$target" != "$save/$master" ]
                             then if [ -f $save/$master/newdata ]
                                  then cat $save/$master/newdata \
                                       >> $target/newdata
                                       rm -f $save/$master/newdata
                                  fi
                             fi

                             # Now pick up the latest updates

                             cat $source/newdata >> $target/newdata
                        
                             ;;

                     newcdf) # New entries for /net/cdf

                             # First, pick up entries saved from previous
                             # attempts to update this Sub-Network

                             if [ "$target" != "$save/$master" ]
                             then if [ -f $save/$master/newcdf ]
                                  then cat $save/$master/newcdf \
                                       >> $target/newcdf
                                       rm -f $save/$master/newcdf
                                  fi
                             fi

                             # Now pick up the latest updates

                             cat $source/newcdf >> $target/newcdf
                        
                             ;;

                  newsubnet) # New entries for /etc/drm/subnet

                             # First, pick up entries saved from previous
                             # attempts to update this Sub-Network

                             if [ "$target" != "$save/$master" ]
                             then if [ -f $save/$master/newsubnet ]
                                  then cat $save/$master/newsubnet \
                                       >> $target/newsubnet
                                       rm -f $save/$master/newsubnet
                                  fi
                             fi

                             # Now pick up the latest updates

                             cat $source/newsubnet >> $target/newsubnet
                        
                             ;;

                    newrsrc) # New entries for /etc/drm/finder.rsrc

                             # First, pick up entries saved from previous
                             # attempts to update this Sub-Network

                             if [ "$target" != "$save/$master" ]
                             then if [ -f $save/$master/newrsrc ]
                                  then cat $save/$master/newrsrc \
                                       >> $target/newrsrc
                                       rm -f $save/$master/newrsrc
                                  fi
                             fi

                             # Now pick up the latest updates

                             cat $source/newrsrc >> $target/newrsrc
                        
                             ;;

                  newassign) # New entries for /etc/drm/finder.assign

                             # First, pick up entries saved from previous
                             # attempts to update this Sub-Network

                             if [ "$target" != "$save/$master" ]
                             then if [ -f $save/$master/newassign ]
                                  then cat $save/$master/newassign \
                                       >> $target/newassign
                                       rm -f $save/$master/newassign
                                  fi
                             fi

                             # Now pick up the latest updates

                             cat $source/newassign >> $target/newassign
                        
                             ;;

                    newmdir) # New network mail directories

                             # First, pick up entries saved from previous
                             # attempts to update this Sub-Network

                             if [ "$target" != "$save/$master" ]
                             then if [ -f $save/$master/newmdir ]
                                  then cat $save/$master/newmdir \
                                       >> $target/newmdir
                                       rm -f $save/$master/newmdir
                                  fi
                             fi

                             # Now pick up the latest updates

                             cat $source/newmdir >> $target/newmdir
                        
                             ;;

                    newmpwd) # New network mail password

                             # First, get rid of any old passwords
                             # still around from previous attempts

                             if [ "$target" != "$save/$master" ]
                             then if [ -f $save/$master/newmpwd ]
                                  then rm -f $save/$master/newmpwd
                                  fi
                             fi

                             # Now pick up the latest update

                             copy -o $source/newmpwd $target

                             ;;

                    newipwd) # New 'ilna' login password

                             # First, get rid of any old passwords
                             # still around from previous attempts

                             if [ "$target" != "$save/$master" ]
                             then if [ -f $save/$master/newipwd ]
                                  then rm -f $save/$master/newipwd
                                  fi
                             fi

                             # Now pick up the latest update

                             copy -o $source/newipwd $target

                             ;;

                          *) # Ignore other files
                             ;;
      esac

   done

   # Now pick up leftovers from previous attempts to update this 
   # Sub-Network master node

   if [ -d $save/$master -a "$target" != "$save/$master" ]
   then for file in `lc $save/$master`
        do 
           case $file in
                    newdata) # Entries for /net/data
                             if [ -f $save/$master/newdata ]
                             then cat $save/$master/newdata \
                                  >> $target/newdata
                                  rm -f $save/$master/newdata
                             fi
                             ;;

                     newcdf) # Entries for /net/cdf

                             if [ -f $save/$master/newcdf ]
                             then cat $save/$master/newcdf \
                                  >> $target/newcdf
                                  rm -f $save/$master/newcdf
                             fi
                             ;;

                  newsubnet) # Entries for /etc/drm/subnet

                             if [ -f $save/$master/newsubnet ]
                             then cat $save/$master/newsubnet \
                                  >> $target/newsubnet
                                  rm -f $save/$master/newsubnet
                             fi
                             ;;

                    newrsrc) # Entries for /etc/drm/finder.rsrc

                             if [ -f $save/$master/newrsrc ]
                             then cat $save/$master/newrsrc \
                                  >> $target/newrsrc
                                  rm -f $save/$master/newrsrc
                             fi
                             ;;

                  newassign) # Entries for /etc/drm/finder.assign

                             if [ -f $save/$master/newassign ]
                             then cat $save/$master/newassign \
                                  >> $target/newassign
                                  rm -f $save/$master/newassign
                             fi
                             ;;

                    newmdir) # New network mail directories

                             if [ -f $save/$master/newmdir ]
                             then cat $save/$master/newmdir \
                                  >> $target/newmdir
                                  rm -f $save/$master/newmdir
                             fi
                             ;;

                    newmpwd) # New network mail password

                             if [ -f $save/$master/newmpwd ]
                             then copy -o $save/$master/newmpwd $target
                                  rm -f $save/$master/newmpwd
                             fi
                             ;;

                    newipwd) # New 'ilna' login password

                             if [ -f $save/$master/newipwd ]
                             then copy -o $save/$master/newipwd $target
                                  rm -f $save/$master/newipwd
                             fi
                             ;;

                          *) # Ignore other files
                             ;;
          esac

       done

   fi

   # Now flag the pending updates for the next cron of AUsynch.ss
   # on the Sub-Network master node.

   > $target/ilnaP

   # Finished with this Sub-Network master node, disconnect

   $iDISBIN/Adisconnect.ss $master 

   # Now inform the logical network administator how it went via mail

   case $rtncode in 0) # Update was successful

                       mail -s "Update of Sub-Network Master Nodes" ilna \
                       <<HERE 2>&1
The transfer of the new network configuration data to Sub-Network $master
has been sucessfully completed.  The new data will be applied to the
network configuration files on Sub-Network $master within the hour.
HERE
                       ;;

                    1) # Update was un-successful, could not connect

                       mail -s "Update of Sub-Network Master Nodes" ilna \
                       <<HERE 2>&1
OpenNET connection to Sub-Network $master could not be established,
and the network configuration files could therefore not be updated
on that Sub-Network.

The updates for this Sub-Network have been retained, and will be re-tried
when you make the 'upd - Update Sub-Network master nodes' selection from
the Alnatop menu again.
HERE
                       ;;

                    2) # Update was un-successful, node was busy updating
                       # for an excessive amount of time

                       mail -s "Update of Sub-Network Master Nodes" ilna \
                       <<HERE 2>&1
OpenNET connection to Sub-Network $master was sucessful, but the 
/usr/ilna/netsynch/applied directory was busy for an excessive amount
of time.  The network configuration files could therefore not be updated
on that Sub-Network.

The updates for this Sub-Network have been retained, and will be re-tried
when you make the 'upd - Update Sub-Network master nodes' selection from
the Alnatop menu again.
HERE
                       ;;

   esac

# Finished with all the Sub-Network masters

done

# Now remove the pending files to make sure they are not applied
# twice.

rm -f $source/new*

# All done
