# "Alnap.ss", a shell script to print Sub-Network/Public Server information.

# Copyright 1986 Intel Corporation.

# 03/22/86  gll  Initial entry for iDIS R2.0.
# 04/15/86  ugg  Modified to pass full pathname to lpr
# 08/05/86  gll  Add trap to prevent hangup on user logout.

trap "" 1 2 3 15

# We do this until we run out of names.

# First, prime the loop.  If there is not at least one name (the invoking
# menu macro should insure this), we abort with an error message.

maxlines=62
line=6
pgno=1
ldate="`date`"
continue=yes
snpsname=${1-absent}
snpslist=$*
prnnode=`$iDISBIN/Uselect -es : 2 0 $CURPRTR < /etc/drm/finder.rsrc`

if [ "$prnnode" = "" ]
then OPENNET=n
fi

pid=$$

# Set trap to remove temp file in the event we're aborted

trap "rm -f /usr/tmp/Alnap.$pid; exit" 2 3 15

# Start the output file with a page header.

echo "$ldate   Sub-Network/Public Server Information    Page $pgno\n\n" \
>> /usr/tmp/Alnap.$pid

# Now make sure there is at least one Sub-Network/Public Server to display.

if [ "$snpsname" = "absent" ]
then echo "
Alnap.ss: no Sub-Network/Public Server names specified!" >> /usr/tmp/Alnap.$pid
     if [ "$OpenNET" = "y" ]
     then lpr -r `net name`/usr/tmp/Alnap.$pid
     else lpr -r /usr/tmp/Alnap.$pid
     fi
     exit 1
fi

# Enter the loop and process the first group name.

while [ "$continue" != "c" ]
do

# Establish type of Sub-Network/Public Server

entry=`grep -c ${snpsname} $MASNODEP/etc/drm/subnet`

type=`$iDISBIN/Uselect -s : 1 0 ${snpsname} < $MASNODEP/etc/drm/subnet`

# Get the Ethernet address for this Sub-Network/Public Server.

eaddr=`/iDISboot/Ar $iDISBIN/getnetaddr $snpsname nfs`

if [ "$eaddr" = "" ]
then eaddr="Not found in the nameserver database"
fi

# Get the description.

comment=`$iDISBIN/Uselect -s : 6 0 ${snpsname} < $MASNODEP/etc/drm/subnet`

# Get the UID, GID ranges.

fuid=`$iDISBIN/Uselect -s : 2 0 ${snpsname} < $MASNODEP/etc/drm/subnet`
luid=`$iDISBIN/Uselect -s : 3 0 ${snpsname} < $MASNODEP/etc/drm/subnet`

if [ "$fuid" = "" ]
then uidr="Not Applicable"
else uidr="$fuid - $luid"
fi

fgid=`$iDISBIN/Uselect -s : 4 0 ${snpsname} < $MASNODEP/etc/drm/subnet`
lgid=`$iDISBIN/Uselect -s : 5 0 ${snpsname} < $MASNODEP/etc/drm/subnet`

if [ "$fgid" = "" ]
then gidr="Not Applicable"
else gidr="$fgid - $lgid"
fi

# Now display the information nicely for the administrator.

if [ $entry -eq 0 ]
then echo "========================================================================



    *** COULD NOT FIND A SUB-NETWORK OR PUBLIC SERVER NAMED $snpsname ***





" >> /usr/tmp/Alnap.$pid

else echo "========================================================================

$type Name: $snpsname

Ethernet Address: $eaddr

$type Description: $comment

User  ID Range: $uidr
Group ID Range: $gidr
" >> /usr/tmp/Alnap.$pid
fi

line=`expr $line + 11`

if [ $line -gt $maxlines ]
then pgno=`expr $pgno + 1`
     line=6
echo "\n\n\n\n\n\n$ldate   Sub-Network/Public Server Information    Page $pgno\n\n" \
>> /usr/tmp/Alnap.$pid
fi

# Now move to the next Sub-Network/Public Server, or quit if there are no more.

set $snpslist
shift
snpsname=${1-absent}
snpslist=$*

if [ "$snpsname" = "absent" ]
then continue=c
else

linesleft=`expr $maxlines - $line`

if [ $linesleft -le 11 ]
then 
     case $linesleft in 1) echo "\n\n\n">> /usr/tmp/Alnap.$pid;;
                        2) echo "\n\n\n\n" >> /usr/tmp/Alnap.$pid;;
                        3) echo "\n\n\n\n\n" >> /usr/tmp/Alnap.$pid;;
                        4) echo "\n\n\n\n\n\n" >> /usr/tmp/Alnap.$pid;;
                        5) echo "\n\n\n\n\n\n\n" >> /usr/tmp/Alnap.$pid;;
                        6) echo "\n\n\n\n\n\n\n\n" >> /usr/tmp/Alnap.$pid;;
                        7) echo "\n\n\n\n\n\n\n\n\n" >> /usr/tmp/Alnap.$pid;;
                        8) echo "\n\n\n\n\n\n\n\n\n\n" >> /usr/tmp/Alnap.$pid;;
                        9) echo "\n\n\n\n\n\n\n\n\n\n\n" >> /usr/tmp/Alnap.$pid;;
                       10) echo "\n\n\n\n\n\n\n\n\n\n\n\n" >> /usr/tmp/Alnap.$pid;;
                       11) echo "\n\n\n\n\n\n\n\n\n\n\n\n\n" >> /usr/tmp/Alnap.$pid;;
                       12) echo "\n\n\n\n\n\n\n\n\n\n\n\n\n\n" >> /usr/tmp/Alnap.$pid;;
                       13) echo "\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n" >> /usr/tmp/Alnap.$pid;;
     esac
     pgno=`expr $pgno + 1`
     line=6
     echo "\n\n\n\n$ldate   Sub-Network/Public Server Information    Page $pgno\n\n" \
     >> /usr/tmp/Alnap.$pid
else echo "\n" >> /usr/tmp/Alnap.$pid
     line=`$iDISBIN/Uinc $line 2`
fi

fi

done

# Finally, spool the file to the assigned printer

if [ "$OPENNET" = "y" ] ; then
   lpr -r `net name`/usr/tmp/Alnap.$pid
else
   lpr -r /usr/tmp/Alnap.$pid
fi
