:
# "Aiu.ss", a shell script to add a user to the system.

# Copyright 1983, 1986 Intel Corporation.
 
# 12/04/85  oer  Add optional uid parm
# 12/06/85  oer  Put in support of quick functions
# 12/06/85  oer  PUT IN TEMPORARY CODE TO AUTO BUILD LOGIN ID
# 12/11/85  oer  Put in support for AFORCE option, mainly to support ademo
# 12/11/85  oer  Put in support for ANOGEN option
# 12/18/85  oer  Put in support <login>.pro
# 01/13/86  ugg  Add file_db statements to add user's home and idis_dir
#                    directories to the file database.
# 02/03/86  ugg  Add the iASWBASE menus and shellscripts in to iBASE.
# 02/11/86  gll  Add user action control file creations.
# 02/13/86  ugg  Add .finder.cur
# 02/24/86  ugg  Add idis_dir and rje_dir directory structure creation.
# 04/22/86  gll  Add node name into path for network systems.
# 05/13/86  rhc add PATH for Ar usage
# 05/16/86  gll  Changed to use AUhome.ss to build the workarea directories.
#                Also removed file_db statements previously added by ugg.
# 05/28/86  gll  Changed to accept a fuid parameter for networked systems.

PATH=/bin:/usr/bin	export PATH

name=$1
usr=$2
shell=$3
net=$4		# y=networked n=standalone
fuid=$5         # "" for stand-alone systems
uid=$6		# This is optional

echo
if grep -s \^$name: $etcpath/passwd > /dev/null
	then echo Aiu.ss: $name already exists in "$etcpath/passwd"
	     echo User was not initialized as an iDIS user
	     exit 1
fi

case $AFORCE in
	YES) ;;
	*)
		if [ -f $usr/$name -o -d $usr/$name ] ; then
			echo "Aiu.ss: $usr/$name directory already exists"
			echo User was not initialized as an iDIS user
			exit 1
		fi
		;;
esac

# create a unique user and group id

if [ "$net" = "n" ]
then gid=${uid:-50} # same as uid if specified, else 50
     uid=${uid:=`$iDISBIN/uid 200`} # next available unless specified
     echo $name::$uid:$gid::$usr/$name:$shell >> $etcpath/passwd
else gid=${uid:-50} # same as uid if specified, else 50
     # next available on new node unless specified
     uid=${uid:=`MASNODEP=//$node $iDISBIN/uid $fuid`}
     echo $name::$uid:$gid::$usr/$name:$shell >> $etcpath/passwd
fi

# "set umask so that the user's files are private"

umask 77

# create home directory and various . files
# User directory must be searchable for rje to work

cd $usr

case $AFORCE in
	YES) [ -d $name ] || mkdir $name ;;
	*)   mkdir $name ;;
esac

chmod o+x $name
chown $uid $name; chgrp $gid $name

cd $name

# Create a few user specific files

Template=$etcpath/Templates/KeyOperator
cp $Template/profile ./.profile
cp $Template/mailrc ./.mailrc
cp $Template/finder.cur ./.finder.cur
chown $uid .profile .mailrc .finder.cur
chgrp $gid .profile .mailrc .finder.cur

# Create the remainder of the workarea using /iDISboot/AUhome.ss

Ausr=$name
Kind=user
Auid=$uid
Gid=$gid
NOTRACE=y

export Ausr Kind Auid Gid NOTRACE

/iDISboot/AUhome.ss APPLY

# Build login profile

cp $Template/menusystems/iDIS/login.pro $iDIS/idis/control/${name}.pro
chmod 664   $iDIS/idis/control/${name}.pro
chown $name $iDIS/idis/control/${name}.pro
chgrp 800   $iDIS/idis/control/${name}.pro

# Add name to login.dat

case $ANOGEN in
	YES) ;;		# Already in the iDIS system, or you don't want them in
	*)
	echo "$name;	dev;	zen30;	Top;	y;	y" >> $iDIS/idis/control/login.dat
	;;
esac

# Now make sure any deauthorizations made upon installation take effect

cd $iDIS/idis
MDHOME=$iDIS/menus/md;	export MDHOME

$MDHOME/genacf.ss -s
[ -f error.tmp ] && rm error.tmp

cd $iDIS/idis/control
chmod 664 auth.file
chown 800 auth.file
chgrp 800 auth.file

[ -f auth.file.tmp ] && rm auth.file.tmp
cd $usr
cd $name
