: 'Copyright 1983, 1986 Intel Corporation.'
# "Afxdel.ss"
# deinstall software option
#
# 05/13/86  rhc add PATH for Ar usage
PATH=/bin:/usr/bin	export PATH
if [ "$OPENNET" = "y" ] ; then
  reference="node"
else
  reference="system"
fi
#
node=$1
shift
echo -n "Confirm that you wish to delete the $1 feature (y or n): "
read answer
echo
case $answer in
   y|yes)
	  ;;
   *)
     echo "The $1 feature is not deleted."
     exit 0
     ;;
esac
#
#   First make sure feature installation/deletion is not in progress.
#
$iDISBIN/Flock -x $iDIS/fb_lock -e sleep 0
if [ $? != 0 ] ; then
   echo 
   echo "  Feature installation/deletion is currently under progress"
   echo "   on this $reference. Please try later."
   exit 0
fi
#
idis=`$iDISBIN/Unonode $iDIS`
idisbin=`$iDISBIN/Unonode $iDISBIN`
if [ "$OPENNET" = "y" ]; then
   ttydev=`net name``tty`
else
   ttydev=`tty`
fi
#
# Trap the quit signal, so that we can cleanup files, etc.
#
trap "" 1 2 3 15
#
PATH=/bin:/etc:/usr/bin:.
iDIS=$idis
iDISBIN=$idisbin
export PATH iDIS iDISBIN ttydev
$iDISBIN/Flock -x $iDIS/fb_lock -e env - PATH=$PATH iDIS=$iDIS iDISBIN=$iDISBIN ttydev=$ttydev fbtty=$ttydev $iDISBIN/Afxdel $ttydev $* > $ttydev

#
if [ $? != 0 ] ; then
  echo "
The $1 feature is not deleted.
       "
  exit 1
fi
#
#   See whether there are any errors
if [ -f $iDIS/report ] ; then
  count=`grep -c "^[^> ]" $iDIS/report`
  if [ $count -gt 0 ] ; then
    errors=
  else
    errors="NO "
  fi
fi
#
#   append the latest feature deletion activity information contained
#    in the report file to the zaplog file for future reference.
#
echo "iDIS SOFTWARE FEATURE DELETION on `date`" >> $iDIS/zaplog
echo " " >> $iDIS/zaplog
cat $iDIS/report >> $iDIS/zaplog
echo " " >> $iDIS/zaplog
#
#  Next insert the message as how to look for errors in report file.
#
cd $iDIS
echo "NOTE: Please look for lines that start in column 1" > report.tmp1
echo " (but not with a '>' character) to identify errors, if any." >> report.tmp1
echo " " >> report.tmp1
cat report >> report.tmp1
rm report
mv report.tmp1 report
# 
chown iDIS report debug
chmod 444 report debug
#
#   Now that we are done with the entire feature deletion process,
#    we need to send mail to the person who initiated the feature 
#    installation.
#
if [ "$node" = "" ] ; then
  mail -s "Deletion of $* feature on this system" `logname` > /dev/null <<!
The deletion of $* feature on this system is complete. 
There were ${errors}errors during the feature deletion. 
For more details, please check the report file by selecting 
'view' selection on 'Afinst' menu.
!
else
  mail -s "Deletion of $* feature on node $node" `logname` > /dev/null <<!
The deletion of the $* feature on the node $node is complete. 
There were ${errors}errors during the feature deletion. 
For more details, please check the report file by selecting 
'view' selection on 'Afinst' menu.
!
fi
#
if [ "$errors" = "NO " ] ; then
  echo "
  The feature deletion is successful.
  Please logout and login again to use the new menu system.
  " | tee -a report | tee -a zaplog
else
  echo "
  Errors were encountered during the feature deletion.
  For more details, please check the report file by selecting  
  'view' selection on 'Afinst' menu.
  " | tee -a report | tee -a zaplog
fi
#
echo "/* ----------------------------------------------------------------- */" \     >> zaplog
echo " " >> zaplog
echo
#
