: 'Copyright 1983, 1985 Intel Corp.'
: "Afrest.ss <dirname> <file/subdrawer name>"
: restore a file or subdrawer from diskette

: "change DEV=/dev/rdf0 if you use "*" inch diskettes"
# 05/13/86  rhc add PATH for Ar usage

PATH=/bin:/usr/bin	export PATH
DIR=$1
TARGET=$2
DEV=${DEV=/dev/rdvf0}

: name of the lock file
LOCK=/tmp/rdf0LOCK

if test ! -d $DIR
then
	echo "$DIR is not a drawer (directory)"
	echo "It is possible you have misspelled it, or it will have to be \
created"
	exit 1
fi

: 'PATCHKIT R2.0 -- see if tape installed '
: '		(check for  itp 1  in xenixconf)'
dnam='diskette'
itp=`Uselect -e 0+ 0 lp </sys/conf/xenixconf | Uselect -s p 1`
itp=${itp:=0}
if [ $itp = 1 ] ; then
    resp=x
    while [ .$resp != .t -a .$resp != .d ] ; do
	echo -n "Do you want to restore from tape or from diskette? (t or d)  "
	read resp
	echo
    done
    if [ $resp = t ] ; then
	LOCK=/tmp/itpLOCK
	dnam=tape
	DEV=/dev/rmt0
    else
	itp=0
    fi
fi

: see if the device is in use
if test -f $LOCK
then
	echo "The lock still exists for the $dnam unit."
	echo -n "It is possible that it is in use; do you want the lock removed?\
 (y or n): "
	read resp
	if test $resp\R != yR
	then
		exit 1
	fi

	rm -f $LOCK
fi

: "remove lock when Afrest.ss exits (normally or abnormally)"
trap "rm -f $LOCK; exit" 0 1 2 3 15

: reserve the device
cp /dev/null $LOCK

echo "You can press the DEL key to cancel this process if need be"
echo
echo "Preparing to load $TARGET"
echo "into $DIR"
echo "If $TARGET is not echoed, it does not exist on the $dnam"
echo "(It must be specified exactly as shown by the list menu selection)"
echo
echo "Mount the first $dnam to search through and enter y"
read resp
if test $resp\R != yR
then
	exit 1
fi

cd $DIR

resp=y
until test $resp\R != yR
do
	if [ $itp = 1 ] ; then
		echo "Do you want to retension the tape?  (Recommended if "
		echo -n "the tape has not been recently used)  (y or n):  "
		read resp2
		echo
		if [ .$resp2 = .y ] ; then
			echo "Retensioning tape ..."
			echo
			retension /dev/rmt0
		fi
	fi
	tar xvf $DEV $TARGET
	STATUS=$?
	echo "Do you have another $dnam to search through for $TARGET?"
	echo "If so, mount it and enter y"
	echo "-or- enter n"
	read resp
done

if test $STATUS -eq 0
then
	echo "Do you wish to review $TARGET,"
	echo "within $DIR, to be certain that the"
	echo "proper ownership and attributes have been established?"
	echo -n "Enter (y or n): "
	read resp
	if test $resp\R = yR
	then
		ls -l $TARGET | more
	fi
fi
