:
# "Aconnect.ss", a shell script to perform a net use to an existing
#                 node using $LOGINID or specified account name.

# Copyright 1986 Intel Corporation

# 05/07/86  gll  Written for iDIS R2.0.
# 06/19/86  ugg  Modified "echo for password" to put a <cr>

#  Parameters:
#      1  --  '-l <loginid>' means to connect as '<loginid>'
#      2  --  '-r' means to connect as 'root'
#      3  --  Node name

if [ $# -eq 0 ]
then echo "
No node specified for connection.

usage: Aconnect.ss [-l <loginid>] [-p <password>] [-r] <node>
"
     exit 1
fi

while [ $# -gt 0 ]
do case $1 in -r) LOGINID=root
                  export LOGINID
                  ;;

              -l) shift
                  if [ "$1" != "" ]
                  then LOGINID=$1
                       export LOGINID
                  else echo "
Expected login account was not given.

usage: Aconnect.ss [-l <loginid>] [-p <password>] [-r] <node>
"
                       exit 1
                  fi
                  ;;

              -p) shift
                  passwd=$1
                  popt=y
                  ;;

               *) node=$1
                  export node
                  ;;
    esac
    shift
done

if [ "$node" = "" ]
then echo "
No node name was specified.

usage: Aconnect.ss [-l <loginid>] [-p <password>] [-r] <node>
"
     exit 1
fi

#   Make sure the specified entry already exists.

count=`grep -c "^$node/" $MASNODEP/net/data`

if [ $count -eq 0 ]
then echo "
The $node node does not exist in the nameserver database.
Please check for spelling errors and retry.
"
     exit 1
fi 

#  Next try to talk to the node.

if [ "$MASNODE" = "$node" ]
then : no need to net use
     rtncod=0
else if [ "$popt" != "y" ]
     then echo "
Please enter the \"${LOGINID}\" password for node ${node} when asked ..."
          net use $node //$node/$LOGINID > /dev/null
          rtncod=$?
     else net use $node //$node/$LOGINID "$passwd" > /dev/null 2>&1
          rtncod=$?
     fi
fi

if [ $rtncod -ne 0 ]
then if [ "$popt" != "y" ]
     then echo "

Could not establish a connection to node ${node}.

You must enable both the OpenNET server and OpenNET consumer 
on node \"${node}\" and enter the correct \"${LOGINID}\" password
for this operation to succeed.
"
    fi
    exit 1
fi

if [ "$popt" = "y" ]
then : no need for new line
else echo
fi
