###########################################
# restore selected units from tar archive #
###########################################
# Copyright 1986 Intel Corporation.
F=$1
I=$2
J=$3
trap "cd /usr/tmp;rm -f $F $I $J*;exit" 0 1 2 3 15
filename=$4
cd /usr/tmp
if [ ! -s $I ] ; then
   echo "
 You did not choose any units to restore.  If you wish to restore any units,
 you must select them.  This can be done from this menu's 'unit' selection."

   # go through some gyrations to remove the lock file that exists
   if [ "$OPENNET" = "y" ]; then
	nodename=`Uselect -s : 2 0 $CURDEV < /etc/drm/finder.rsrc`
	devnode=//$nodename
   else
	devnode=""
   fi
   rm -rf $devnode/tmp/$CURDEV
   exit 1
fi
chmod +x $I
$I >$J
LIST=`	sort -n -u $J  | tr ':' ' ' |
	while read LINE; do
		set $LINE
		echo $2 >> $J.$3
		if [ "$3" != "$LASTVOL" ];then
			echo " $3"
			LASTVOL=$3
		fi
	done`
umask 0
if [ $CURDEV != "unassigned" ]; then
	curtype=`Uselect -s : 1 0 $CURDEV < /etc/drm/finder.rsrc`
	blocking="`Uselect -s : 1 0 $curtype \
				< /etc/drm/finder.usage | tr ';' ' '`"
	device=`Uselect -s : 3 0 $CURDEV < /etc/drm/finder.rsrc`
else
	echo "\n Current device is unassigned.\n"\
		"Choose \"chng\" from menu to select a device for save/restore."
	exit 1
fi
if [ "$OPENNET" = "y" ]; then
	nodename=`Uselect -s : 2 0 $CURDEV < /etc/drm/finder.rsrc`
	devnode=//$nodename
else
	devnode=""
fi
##############
NOTALLOWED="The work area selected is not on a node which you are allowed to administer."
AUTH=`Aauthority.ss $LOGINID`
case $AUTH in
	keyoperator)
		NODELIST=`Argetnodes.ss $LOGINID keyoperator | tr '\012' ' '`
		ASK=yes
	;;
	lognetadmin|subnetadmin)
		ASK=yes
	;;
	*)
		ASK=no
	;;
esac

if [ "$ASK" = "yes" ]; then 
PASS=/etc/passwd
OP=restore
if [ "$OPENNET" = "y" ]; then
	echo -n \
	"\n Current work area is the $WATYPE work area on the $WORKSYS node.\n"
else
	echo -n \
	"\n Current work area is the $WATYPE work area.\n"
fi
while [ TRUE ] ; do
echo -n "\n Please enter the type of work area into which you want to $OP\n"\
			"(c=current i=individual g=group p=public): "
read RESP
case $RESP in 
	c*)	break
	;;
	i*)	echo -n "\n Please enter the loginid of the user"\
			"\n into whose work area you want to $OP: "
		read ID
		NEWHOME=`Uselect -s : 5 0 $ID < $PASS`
		if [ "$NEWHOME" != "" ]; then
			if [ "$AUTH" = "keyoperator" ]; then
				echo $NODELIST |
				grep `Ustripnode $NEWHOME` > /dev/null
				case $? in
					0) 	HOME=$NEWHOME
						break
					;;
					*)	if [ "$OPENNET" = "y" ]; then
							echo "\n $NOTALLOWED"
						else
							HOME=$NEWHOME
							break
						fi
					;;
				esac
			else
				HOME=$NEWHOME
				break
			fi
		else 
			echo "\n $ID is not a valid login.\n"
		fi
	;;
	g*)	echo -n "\n Please enter the name of the group work"\
			"area into which you want to $OP: "
		read ID
		NEWHOME=`Uselect -s : 5 0 $ID < $PASS`
		if [ "$NEWHOME" != "" ]; then
			if [ "$AUTH" = "keyoperator" ]; then
				echo $NODELIST |
				grep `Ustripnode $NEWHOME` > /dev/null
				case $? in
					0) 	HOME=$NEWHOME
						break
					;;
					*)	if [ "$OPENNET" = "y" ]; then
							echo "\n $NOTALLOWED"
						else
							HOME=$NEWHOME
							break
						fi
					;;
				esac
			else
				HOME=$NEWHOME
				break
			fi
		else 
			echo "\n $ID is not a valid group workarea.\n"
		fi
	;;
	p*)	echo -n "\n Please enter the name of the"\
			"public work area into which you want to $OP: "
		read ID
		NEWHOME=`Uselect -s : 5 0 $ID < $PASS`
		if [ "$NEWHOME" != "" ]; then
			if [ "$AUTH" = "keyoperator" ]; then
				echo $NODELIST |
				grep `Ustripnode $NEWHOME` > /dev/null
				case $? in
					0) 	HOME=$NEWHOME
						break
					;;
					*)	if [ "$OPENNET" = "y" ]; then
							echo "\n $NOTALLOWED"
						else
							HOME=$NEWHOME
							break
						fi
					;;
				esac
			else
				HOME=$NEWHOME
				break
			fi
		else 
			echo "\n $ID is not a valid public workarea.\n"
		fi
	;;
esac
done
fi
#########
# name of the lock file
LOCK=$devnode/tmp/$CURDEV

# see if the device is in use
if [ -f $LOCK ] ; then
   set `cat $LOCK`
   menuid=$1
   owner=$2
   case $menuid in
      $MENUID) ;;	# It is us, everything is o.k.
      *)
	  echo "
 It is possible that the $CURDEV drive is in use by someone else.  Our
 information suggests that it is in use by a user whose login ID is $owner.
 It is recommended that you physically examine the drive to determine if it is
 in fact being used.

 You will be given an opportunity to go ahead with this operation.  If you
 do go ahead, and the $CURDEV drive IS in use it is possible that you will
 destroy any data that exists on $owner's media.\n"

	  while :
	  do
	      echo -n " Do you wish to go ahead with this operation (y or n)? "
	      read resp
	      case $resp in
		y*|Y*)	rm -f $LOCK
			break ;;
		n*|N*)	echo " Operation has been canceled."
			exit 1 ;;
		*)	echo "\n Invalid response <$resp>, please respecify"
	      esac
	  done
      ;;
   esac
fi

# remove lock when script exits (normally or abnormally)
# preserve old trap information
trap "rm -f $LOCK;cd /usr/tmp;rm -f $F $I $J*;trap 0; exit" 0 1 2 3 15

# reserve the device
echo "$MENUID $LOGINID" > $LOCK
chmod 666 $LOCK

cd $HOME
case $curtype in

	5-in-diskette|8-in-diskette)
	for VOL in $LIST; do
		echo -n " Please insert backup diskette volume $VOL.\n" \
		     	"Press return when ready."
		read x
		tar xnvfF $devnode$device /usr/tmp/$J.$VOL
	done
	;;

	directory)
	echo -n " Ready to begin restoring into the workarea.\n"\
		"Press return to start."
	read x
	tar xvfF $devnode/$device/$filename /usr/tmp/$J.1
	;;

	streamertape)
	for VOL in $LIST; do
		echo -n " Please insert backup tape cartridge volume $VOL.\n"\
			"Press return when ready. "
		read x
		if [ "$OPENNET" = "y" ]; then
			pwd=`pwd`
			COMMAND="/bin/tar xvfF $device //$PHYSYS/usr/tmp/$J.$VOL "
			/iDISboot/Aartar.ss "${COMMAND}" //$WORKSYS`Unonode $pwd` $nodename
		else
			tar xvfF $device /usr/tmp/$J.$VOL
		fi
	done
	;;

	9tracktape)
	for VOL in $LIST; do
		echo -n " Please insert backup tape reel volume $VOL.\n"\
			"Press return when ready. "
		read x
		if [ "$OPENNET" = "y" ]; then
			pwd=`pwd`
			COMMAND="/bin/tar xvfF $device //$PHYSYS/usr/tmp/$J.$VOL "
			/iDISboot/Aartar.ss "${COMMAND}" //$WORKSYS`Unonode $pwd` $nodename
		else
			tar xvf $device
		fi
	done
	;;
esac
