:
# "Aapasswd.ss", a shell script to handle password changes by individuals
#                and administrators.

# Copyright 1986 Intel Corporation.

# 05/22/86  gll  Added special handling of the 'ilna' login password.
# 06/13/86  gll  Filter out OpenNET account and tell to use the
#                modify network mail password selection from the
#                Alnatop menu instead.
# 07/06/86  gll  Merged in changes made by rhc between x007 and x009.
# 08/06/86  rhc  Altered logic to allow the idis loginid to change the 
#                passwords of others.

# If Logical Network Administrator or Sub-Network administrator,
# we ask which password to change, else we allow changing self only.

A=`Aauthority.ss $LOGINID`
if [ "$A" = "subnetadmin" -o "$A" = "lognetadmin" -o $LOGINID = "idis" ]; then
	echo -n "
Please enter loginid for which to change password - "
	read loginid

	# Do NOT allow changing of the network mail password here

	if [ "$loginid" = "OpenNET" ]
	then if [ "$LOGINID" != "ilna" ]
	     then echo "
Only the logical network administrator can change this password."
		  exit 1
             else echo "
The 'OpenNET' account password (the network mail password) cannot
be changed using this selection.

Please use the 'mpwd - Modify network mail password' selection
from the Alnatop menu to change the network mail password."
		  exit 0
             fi
        fi

        # Use special handling for the 'ilna' password

        if [ "$loginid" = "ilna" ]
        then if [ "$LOGINID" != "ilna" ]
             then echo "
Only the logical network administrator can change this password."
                  exit 1
             else echo
                  ilnaepw=`$iDISBIN/Apwgen \`$iDISBIN/Agetpasswd\``
                  ilnahome=`$iDISBIN/Uselect -s : 5 0 ilna \
                  < $MASNODEP/etc/passwd`
                  ilnaexec=`$iDISBIN/Uselect -s : 6 0 ilna \
                  < $MASNODEP/etc/passwd`
                  echo "ilna:$ilnaepw:800:800:The Logical Network Administrator:$ilnahome:$ilnaexec" > $MASNODEP/usr/ilna/netsynch/pending/newipwd
                  echo "
Password change has been recorded, but NOT applied.

The new 'ilna' password will be updated network-wide when you make the
'upd - Update Sub-Network master nodes' selection from the Alnatop menu."
             fi
	else if [ "$loginid" = "$LOGINID" ]
             then while [ TRUE ]
                  do passwd
                     case $? in 0) break ;;
                                *) continue ;;
                     esac
                  done
                  if [ "$OPENNET" = "y" ]
                  then echo "
Password change has been done on the master node and on the local node.

It will be effective on the rest of the network within an hour."
                  fi
             else while [ TRUE ]
                  do echo -n "Please enter root "
                     /iDISboot/Ar /bin/passwd $loginid
                     case $? in 0) break ;;
                                *) continue ;;
                     esac
                  done
                  if [ "$OPENNET" = "y" ]
                  then echo "
Password change has been done on the master node and on the local node.

It will be effective on the rest of the network within an hour."
                  fi
             fi
        fi
else if [ "$LOGINID" = "ilna" ]
     then echo
          ilnaepw=`$iDISBIN/Apwgen \`$iDISBIN/Agetpasswd\``
          ilnahome=`$iDISBIN/Uselect -s : 5 0 ilna \
          < $MASNODEP/etc/passwd`
          ilnaexec=`$iDISBIN/Uselect -s : 6 0 ilna \
          < $MASNODEP/etc/passwd`
          echo "ilna:$ilnaepw:800:800:The Logical Network Administrator:$ilnahome:$ilnaexec" > $MASNODEP/usr/ilna/netsynch/pending/newipwd
          echo "
Password change has been recorded, but NOT applied.

The new 'ilna' password will be updated network-wide when you make the
'upd - Update Sub-Network master nodes' selection from the Alnatop menu."

      else while [ TRUE ]
           do passwd
              case $? in 0) break ;;
                         *) continue ;;
              esac
           done
           if [ "$OPENNET" = "y" ]
           then echo "
Password change has been done on the master node and on the local node.

It will be effective on the rest of the network within an hour."
           fi
      fi
fi
