:
# "Aaddsn.ss", a shell script to add a new subnet master to the network.

# Copyright 1986 Intel Corporation.

# 05/07/86  gll  Written for iDIS R2.0.
# 06/27/86  gll  SPR 83.  Modified to ask user if init should continue
#                         if node is already there, then to proceed if
#                         the answer is yes.  Also remove duplicate
#                         /net/data entries upon completion.
# 07/03/86  gll  Added restoration of files if configure.idis aborts.
#                Also no longer place new subnet masters resources
#                on the other master nodes.
# 07/14/86  ugg  Removed all the "duplicate entry removal logic" and put
#                in to Armsndups.ss to get around the core dump problem.
# 07/16/86  gll  created the "idisp" variable to simplify changing
#                location of iDIS.
# 08/12/86  gll  Modified to abort on overinstalls.  Corrected permissions
#                on LNM update files.  More info given when previous iDIS
#                found.

# Bring in the parameters:
#
#      1  --  Sub-Network Master Node Name
#      2  --  Sub-Network Master Node Password
#      3  --  Sub-Network Master Node Ethernet address
#      4  --  Sub-Network first user id value
#      5  --  Sub-Network last user id value
#      6  --  Sub-Network first group id value
#      7  --  Sub-Network last group id value
#      8  --  Sub-Network Master Node Description
#

idisp=usr/iDIS

node=$1
shift
passwd=$1
shift
address=$1
shift
fuid=$1
shift
luid=$1
shift
fgid=$1
shift
lgid=$1
shift
comment="$*"

echo "
Validating information specified for Sub-Network $node ..."

# Determine current legal uid and gid ranges.

maxuid=32767
maxgid=32767

lastuid=`$iDISBIN/Asnranges.ss uid`
lastgid=`$iDISBIN/Asnranges.ss gid`

minuid=`expr $lastuid + 1`
mingid=`expr $lastgid + 1`

# Validate the uid, gid values.

if [ "$fuid" = "automatic" ]
then fuid=$minuid
else # see if numeric
     fuidsz=`expr $fuid : '.*'`
     ndigits=`expr $fuid : '[0-9]*'`
     if [ $fuidsz -ne $ndigits ]
     then echo "
The first User ID value must be the word \"automatic\" or a
number between $minuid and $maxuid.  You entered $fuid."
          exit 1
     fi
     if [ $fuid -lt $minuid -o $fuid -gt $maxuid ]
     then echo "
The first User ID value must be the word \"automatic\" or a
number between $minuid and $maxuid.  You entered $fuid."
          exit 1
     fi
fi
if [ "$fgid" = "automatic" ]
then fgid=$mingid
else # see if numeric
     fgidsz=`expr $fgid : '.*'`
     ndigits=`expr $fgid : '[0-9]*'`
     if [ $fgidsz -ne $ndigits ]
     then echo "
The first Group ID value must be the word \"automatic\" or a
number between $mingid and $maxgid.  You entered $fgid."
          exit 1
     fi
     if [ $fgid -lt $mingid -o $fgid -gt $maxgid ]
     then echo "
The first Group ID value must be the word \"automatic\" or a
number between $mingid and $maxgid.  You entered $fgid."
          exit 1
     fi
fi

availuids=`expr $maxuid - $fuid`
availgids=`expr $maxuid - $fgid`

case $luid in +*) luid=`echo $luid | sed -e s/+//`
                  # see if numeric
                  luidsz=`expr $luid : '.*'`
                  ndigits=`expr $luid : '[0-9]*'`
                  if [ $luidsz -ne $ndigits ]
                  then echo "
The last User ID value must be a number between $fuid and $maxuid,
or a value to be added to the first User ID value, entered as +<num>,
where <num> is between 1 and $availuids.  You entered +$luid."
                       exit 1
                  fi
                  if [ $luid -lt 1 -o $luid -gt $availuids ]
                  then echo "
The last User ID value must be a number between $fuid and $maxuid,
or a value to be added to the first User ID value, entered as +<num>,
where <num> is between 1 and $availuids.  You entered +$luid."
                       exit 1
                  fi
                  luid=`expr $fuid + $luid`
                  ;;

               *) # see if its numeric. 
                  luidsz=`expr $luid : '.*'`
                  ndigits=`expr $luid : '[0-9]*'`
                  if [ $luidsz -ne $ndigits ]
                  then echo "
The last User ID value must be a number between $fuid and $maxuid,
or a value to be added to the first User ID value, entered as +<num>,
where <num> is between 1 and $availuids.  You entered $luid."
                       exit 1
                  fi
                  if [ $luid -lt $fuid -o $luid -gt $maxuid ]
                  then echo "
The last User ID value must be a number between $fuid and $maxuid,
or a value to be added to the first User ID value, entered as +<num>,
where <num> is between 1 and $availuids.  You entered $luid."
                       exit 1
                  fi
                  ;;
esac

case $lgid in +*) lgid=`echo $lgid | sed -e s/+//`
                  # see if numeric
                  lgidsz=`expr $lgid : '.*'`
                  ndigits=`expr $lgid : '[0-9]*'`
                  if [ $lgidsz -ne $ndigits ]
                  then echo "
The last Group ID value must be a number between $fgid and $maxgid,
or a value to be added to the first Group ID value, entered as +<num>,
where <num> is between 1 and $availgids.  You entered +$lgid."
                       exit 1
                  fi
                  if [ $lgid -lt 1 -o $lgid -gt $availgids ]
                  then echo "
The last Group ID value must be a number between $fgid and $maxgid,
or a value to be added to the first Group ID value, entered as +<num>,
where <num> is between 1 and $availgids.  You entered +$lgid."
                       exit 1
                  fi
                  lgid=`expr $fgid + $lgid`
                  ;;

               *) # see if its numeric. 
                  lgidsz=`expr $lgid : '.*'`
                  ndigits=`expr $lgid : '[0-9]*'`
                  if [ $lgidsz -ne $ndigits ]
                  then echo "
The last Group ID value must be a number between $fgid and $maxgid,
or a value to be added to the first Group ID value, entered as +<num>,
where <num> is between 1 and $availgids.  You entered $lgid."
                       exit 1
                  fi
                  if [ $lgid -lt $fgid -o $lgid -gt $maxgid ]
                  then echo "
The last Group ID value must be a number between $fgid and $maxgid,
or a value to be added to the first Group ID value, entered as +<num>,
where <num> is between 1 and $availgids.  You entered $lgid."
                       exit 1
                  fi
                  ;;
esac

# Set a couple of known variables.

process=nfs
type=XENIX
oldnode=n

save=$MASNODEP/usr/ilna/netsynch
updates=$MASNODEP/usr/ilna/netsynch/pending

export node address comment process type fuid luid fgid lgid

# Make sure the specified entry already does not exist.
# We have to do this because mkns does not return an error code.

count=`grep -c "^$node:" $MASNODEP/etc/drm/subnet`

if [ $count -ne 0 ] # Its already a Sub-Network master or Public Server.
then echo "
The entry for node $node already exists in $MASNODEP/etc/drm/subnet.

Node $node has NOT been overwritten."
     exit 1
fi

count=`grep -c "^$node/" $MASNODEP/net/data`

if [ $count -gt 0 ] # Its already present as another node type.
then echo -n "
The entries for $node already exist in the nameserver database.

Node $node has NOT been overwritten."
     exit 1
fi 

# Check for validity of the Ethernet address.

a=`expr $address : '.*'`

if [ $a -lt 12 ]
then echo "
The address $address is not valid.  The address MUST be 12 characters long.

The Sub-Network $node has not been added to the network."
     exit 1
else a=`expr $address : '[0-9a-fA-F]*'`

     if [ $a -lt 12 ]
     then echo "
The address $address is not valid.  The address MUST consist of hexadecimal
digits only: (0,1,2,3,4,5,6,7,8,9,A,B,C,D,E,F) 

The Sub-Network $node has not been added to the network."
          exit 1
     fi

fi  

# Set a trap so user can't kill from here forward.

trap "" 1 2 3 15

#  Next make the nfs entry in /net/data

/etc/mkns <<HERE >/dev/null
addname
$node/$process
$type
y
8000
y
$address
done
HERE

if [ $? != 0 ]
then echo "
Could not create nfs entry for $node in master /net/data file.

The Sub-Network $node has not been added to the network."
     exit 1
fi

#  Next try to talk to the new node.

echo "
Attempting OpenNET connection to Sub-Network $node ...
"

$iDISBIN/Aconnect.ss -l root $node

# If we cannot talk, remove the entry from the nameserver database,
# and abort the operation.

if [ $? != 0 ]
then echo "
The Sub-Network $node has not been added to the network."

     if [ "$oldnode" = "n" ]
     then # remove /net/data entry only if it wasnt already there.
          sed -e "/^$node\/$process/d" $MASNODEP/net/data \
            > $MASNODEP/tmp/netdata$$
          mv $MASNODEP/tmp/netdata$$ $MASNODEP/net/data
          chmod 644 $MASNODEP/net/data
     fi
     exit 1

# If we can talk to the new Sub-Network master, make entries to subnet file,
# build initial DRM entries, and place a valid /net/data and /net/cdf
# on the new master.

else
     SCPFILE=//$node/usr/intel/scp/configurations/current
     if [ ! -f $SCPFILE ]
     then echo "
Can not access the current system configuration file on node ${node}.

Configuration of node ${node}'s file systems, printers, terminal ports,
etc., must be performed before it can become a Sub-Network Master node.

If you have already performed this configuration, it is probable that the
'usr' file system on node $node is not mounted. Please check and try again.

The Sub-Network $node has not been added to the network."

          #  Delete all the entries created so far.
          sed -e "/^$node\//d" $MASNODEP/net/data > $MASNODEP/tmp/netdata$$
          mv $MASNODEP/tmp/netdata$$ $MASNODEP/net/data
          chmod 644 $MASNODEP/net/data

     else # Check for previous installation of iDIS software.

          # Start by assuming no previous installations.

          piDIS=n

          # Now look for iDIS R1.6

          if [ -d //$node/iDISbin ]
          then echo "
Previously installed iDIS software found in /iDISbin on node $node."
               piDIS=y
          fi

          # Look for overinstall of iDIS R2.0

          if [ -d //$node/usr/iDISbin ]
          then echo "
Previously installed iDIS software found in /usr/iDISbin on node $node."
               piDIS=y
          fi

          if [ -d //$node/iDISboot ]
          then echo "
Previously installed iDIS software found in /iDISboot on node $node."
               piDIS=y
          fi

          # See if OpenNET Configuration files are as per instructions.

          set A `sed -e "/^$node/d" //$node/net/data | wc`
          numentry=$2

          if [ $numentry -ne 0 ]
          then echo "
There are nodes improperly listed in the nameserver database on node $node."
               piDIS=y
          fi

          set A `wc //$node/net/cdf`
          numentry=$2

          if [ $numentry -gt 1 ]
          then echo "
There are nodes improperly listed in the consumer database on node $node."
               piDIS=y
          else if [ $numentry -lt 1 ]
               then echo "
This node's entry to the consumer database is missing on node $node."
                    piDIS=y
               else numentry=`grep -c "^$node:" //$node/net/cdf`
                    if [ $numentry -eq 0 ]
                    then echo "
The consumer database entry is incorrect on node $node."
                         piDIS=y
                    fi
               fi
          fi

          # Now see if we found anything and if so, abort.

          if [ "$piDIS" = "y" ]
          then echo "
This initialization cannot be completed for the above reasons.

Backing out initialization performed so far, please wait ..."

               #  Delete all the entries created so far.
               sed -e "/^$node\//d" < $MASNODEP/net/data \
		 > $MASNODEP/tmp/netdata$$
               mv $MASNODEP/tmp/netdata$$ $MASNODEP/net/data
               chmod 644 $MASNODEP/net/data

               # Now make sure no duplicates in /net/data, /net/cdf, and
               # the finder.rsrc, finder.assign files on the master node.

               cat $MASNODEP/net/data | sort -u > $MASNODEP/net/data.tmp
               chmod 644 $MASNODEP/net/data.tmp
               chgrp root $MASNODEP/net/data.tmp
               chown root $MASNODEP/net/data.tmp
               mv $MASNODEP/net/data.tmp $MASNODEP/net/data
          
               cat $MASNODEP/net/cdf | sort -u > $MASNODEP/net/cdf.tmp
               chmod 644 $MASNODEP/net/cdf.tmp
               chgrp root $MASNODEP/net/cdf.tmp
               chown root $MASNODEP/net/cdf.tmp
               mv $MASNODEP/net/cdf.tmp $MASNODEP/net/cdf
          
               cat $MASNODEP/etc/drm/finder.rsrc | sort -u \
                 > $MASNODEP/etc/drm/rsrc.tmp
               chmod 664 $MASNODEP/etc/drm/rsrc.tmp
               chgrp 800 $MASNODEP/etc/drm/rsrc.tmp
               chown 800 $MASNODEP/etc/drm/rsrc.tmp
               mv $MASNODEP/etc/drm/rsrc.tmp $MASNODEP/etc/drm/finder.rsrc
          
               cat $MASNODEP/etc/drm/finder.assign | sort -u \
                 > $MASNODEP/etc/drm/assign.tmp
               chmod 664 $MASNODEP/etc/drm/assign.tmp
               chgrp 800 $MASNODEP/etc/drm/assign.tmp
               chown 800 $MASNODEP/etc/drm/assign.tmp
               mv $MASNODEP/etc/drm/assign.tmp $MASNODEP/etc/drm/finder.assign
          
               # Disconnect from the node

               $iDISBIN/Adisconnect.ss $node

	       echo -n "
Press RETURN to continue ..."
	       read resp

               exit 0
          fi

	  echo "
Setting up Sub-Network Master $node ..."

          # make the /etc/drm/subnet entry on LNMASTER
          echo "${node}:Sub-Network:$fuid:$luid:$fgid:$lgid:$comment" \
          >> $MASNODEP/etc/drm/subnet

          # make the subnet entry to netsynch/pending for other subnets

          echo "${node}:Sub-Network:$fuid:$luid:$fgid:$lgid:$comment" \
          >> $updates/newsubnet
	  chmod 664 $updates/newsubnet
	  chgrp 800 $updates/newsubnet
	  chown 800 $updates/newsubnet

          # make an nfc entry to LNMASTER /net/data
          /etc/mkns <<HERE >/dev/null
addname
$node/nfc
$type
y
8100
y
$address
done
HERE

          # if VT has been installed on the new SNMASTER, make those
          # /net/data entries too.
          count=`grep -c "^VT" $SCPFILE`
          if [ $count -gt 0 ]
          then # make the vts entry on LNMASTER
               /etc/mkns <<HERE >/dev/null
addname
$node/vts
XVTSRV
y
4000
y
$address
done
HERE
               # make the vtc entry on LNMASTER
               /etc/mkns <<HERE >/dev/null
addname
$node/vtc
XVTCON
y
4100
y
$address
done
HERE
          fi

          # make /net/data entries to netsynch/pending for the other subnets

          grep "^$node" $MASNODEP/net/data >> $updates/newdata
	  chmod 664 $updates/newdata
	  chgrp 800 $updates/newdata
	  chown 800 $updates/newdata

          # make entry to LNMASTER /net/cdf, service level 2
          /etc/mkcon -c $node $passwd 2

          # make /net/cdf entry to netsynch/pending for the other subnets

          grep "^$node" $MASNODEP/net/cdf >> $updates/newcdf
	  chmod 664 $updates/newcdf
	  chgrp 800 $updates/newcdf
	  chown 800 $updates/newcdf

          # construct a /net/cdf on the new Sub-Network Master
          
          # service level 2,1 for the new SNMASTER
          echo "`grep $node $MASNODEP/net/cdf`,1" \
          > //$node/net/cdf

          # service level 2 for LNMASTER, other SNMASTERS

          for master in `$iDISBIN/Uselect -s : 0 1 Sub-Network \
          < $MASNODEP/etc/drm/subnet`
          do
             if [ "$master" != "$node" ]
             then set `grep $master $MASNODEP/net/cdf \
                      | $iDISBIN/Uselect -s : 0,1`
                  echo "$1:$2:2" >> //$node/net/cdf
             fi
          done

          # construct a /net/data on the new Sub-Network Master

          # all entries for other network master nodes

          for master in `$iDISBIN/Uselect -s : 0 1 Sub-Network \
          < $MASNODEP/etc/drm/subnet`
          do
             echo "`grep $master $MASNODEP/net/data`" \
             >>//$node/net/data
          done
 
          # nfs,vts entries for public servers
          for server in `$iDISBIN/Uselect -s : 0 1 "Public Server" \
          < $MASNODEP/etc/drm/subnet`
          do
             echo "`grep ${server}/nfs $MASNODEP/net/data`" \
             >> //$node/net/data
             echo "`grep ${server}/vts $MASNODEP/net/data`" \
             >> //$node/net/data
          done

          # Add OpenNET mail directory to netsynch/pending for other subnets

          echo $node >> $updates/newmdir
	  chmod 664 $updates/newmdir
	  chgrp 800 $updates/newmdir
	  chown 800 $updates/newmdir

          # invoke configure.idis to push iBASE and other files
          # down to the new Sub-Network master.  Also configures
          # OpenNET mail on both LNMASTER and new SNMASTER.

          /iDISboot/Ar $MASNODEP/$idisp/iBASE/configure.idis -s $node

          if [ $? -ne 0 ]
          then # Backout everything so far and abort.

               echo "
Restoring all files already modified."
               
               # restore master nodes subnet file

               sed -e "/^${node}:/d" $MASNODEP/etc/drm/subnet \
                 > $MASNODEP/tmp/subnet$$
               mv $MASNODEP/tmp/subnet$$ $MASNODEP/etc/drm/subnet
               chmod 664 $MASNODEP/etc/drm/subnet
               chgrp 800 $MASNODEP/etc/drm/subnet
               chown 800 $MASNODEP/etc/drm/subnet

               # also remove from pending transactions file

               sed -e "/^${node}:/d" $updates/newsubnet \
                 > $MASNODEP/tmp/newsn$$
               set A `l $MASNODEP/tmp/newsn$$ 2> /dev/null`
               outlen=${6-0}
               if [ $outlen -eq 0 ]
               then rm -f $MASNODEP/tmp/newsn$$ $updates/newsubnet
               else mv $MASNODEP/tmp/newsn$$ $updates/newsubnet
                    chmod 664 $updates/newsubnet
                    chgrp 800 $updates/newsubnet
                    chown 800 $updates/newsubnet
               fi

               # remove new /net/data entries from transaction file

               sed -e "/^$node\//d" $updates/newdata \
                 > $MASNODEP/tmp/newd$$
               set A `l $MASNODEP/tmp/newd$$ 2> /dev/null`
               outlen=${6-0}
               if [ $outlen -eq 0 ]
               then rm -f $MASNODEP/tmp/newd$$ $updates/newdata
               else mv $MASNODEP/tmp/newd$$ $updates/newdata
                    chmod 664 $updates/newdata
                    chgrp 800 $updates/newdata
                    chown 800 $updates/newdata
               fi

               # restore master nodes /net/cdf file

               sed -e "/^${node}:/d" $MASNODEP/net/cdf \
                 > $MASNODEP/tmp/netcdf$$
               mv $MASNODEP/tmp/netcdf$$ $MASNODEP/net/cdf
               chmod 644 $MASNODEP/net/cdf

               # remove from pending transaction file too

               sed -e "/^${node}:/d" $updates/newcdf \
                 > $MASNODEP/tmp/newc$$
               set A `l $MASNODEP/tmp/newc$$ 2> /dev/null`
               outlen=${6-0}
               if [ $outlen -eq 0 ]
               then rm -f $MASNODEP/tmp/newc$$ $updates/newcdf
               else mv $MASNODEP/tmp/newc$$ $updates/newcdf
                    chmod 664 $updates/newcdf
                    chgrp 800 $updates/newcdf
                    chown 800 $updates/newcdf
               fi

               # remove the /net/cdf from the target node

               rm -f //$node/net/cdf

               # restore the target nodes /net/data

               grep "^$node/" //$node/net/data //$node/tmp/netdata
               mv //$node/tmp/netdata //$node/net/data
               chmod 644 //$node/net/data

               # remove target node from pending mail directory 
               # transction file

               sed -e "/^$node/d" $updates/newmdir \
                 > $MASNODEP/tmp/newmd$$
               set A `l $MASNODEP/tmp/newmd$$ 2> /dev/null`
               outlen=${6-0}
               if [ $outlen -eq 0 ]
               then rm -f $MASNODEP/tmp/newmd$$ $updates/newmdir
               else mv $MASNODEP/tmp/newmd$$ $updates/newmdir
                    chmod 664 $updates/newmdir
                    chgrp 800 $updates/newmdir
                    chown 800 $updates/newmdir
               fi
               
               # restore the master nodes /net/data file

               if [ "$oldnode" = "n" ]
               then # remove /net/data entry only if it wasnt already there.
                    sed -e "/^$node\/$process/d" $MASNODEP/net/data \
                      > $MASNODEP/tmp/netdata$$
                    mv $MASNODEP/tmp/netdata$$ $MASNODEP/net/data
                    chmod 644 $MASNODEP/net/data
               fi

               # Now let user know we have not added the sub-network

               echo "
The Sub-Network $node has not been added to the network."
	
               exit 1

          fi

          # Add the ilna password to the new Sub-Network Master

          setsav="dummy $*"

          ORGIFS=$IFS

          IFS=:

          set `$iDISBIN/Uselect -s \: 0+ 0 ilna < $MASNODEP/etc/passwd`

          IFS=$ORGIFS

          # Handle cases with and without comments,passwords

          if [ "$7" != "" ]
          then # Everything here
               echo "$1:$2:$3:$4:$5://$node/usr/ilna:$7" > /tmp/pwe1$$
          else if [ "$6" = "" ]
               then # Missing both password and comment
                    echo "$1::$2:$3:://$node/usr/ilna:$5" > /tmp/pwe1$$
               else if [ "$2" = "800" ]
                    then # Missing just password
                         echo "$1::$2:$3:$4://$node/usr/ilna:$6" > /tmp/pwe1$$
                    else # Missing just comment
                         echo "$1:$2:$3:$4:://$node/usr/ilna:$6" > /tmp/pwe1$$
                    fi
               fi
          fi

          set $setsav
          shift

          sed -e "/^ilna/d" //$node/etc/passwd > /tmp/pwe2$$
          cat /tmp/pwe2$$ /tmp/pwe1$$ > //$node/etc/passwd
          rm -f /tmp/pwe1$$ /tmp/pwe2$$

          # remove duplicates from both subnet master and logical net master
          
          $iDISBIN/Armsndups.ss $node

          # Disconnect from the new Sub-Network master node

          $iDISBIN/Adisconnect.ss $node

          exit 0
     fi
fi
