: 'Copyright 1986 Intel Corp.'
# Build transactions for a target node
# NOTE: There is a companion script to this AUnodeb.ss
# PLEASE KEEP THEM IN SYNCH, AS REQUIRED
# 03/15/86 oer
# 03/30/86 oer misc. cleanup
# 05/08/86 oer change to reference the master node
# 05/28/86 oer make PIDFILE 666, prevents problem when 1st trans. is deferred
# 06/02/86 ugg added group modification transaction processing.

MASSYNCH=$MASNODEP`$iDISBIN/Unonode $iDIS`/synch # Master node synch directory
export MASSYNCH

if [ -f $MASSYNCH/debug ] ; then
	set -x
	echo $0
fi

node=$1
. $2		# set up environment


txn=$node.`$iDISBIN/Anxtxn $node`	# get next transaction number

case $Ttype in
   # INITIALIZE GROUP/WORKAREA
   Init)
      # generate header part of the transaction
      cat <<-\HERE > $txn
	: /bin/sh
	# Initialize $Kind
	PIDFILE=/tmp/$SNODE.P$TNUM 	# Unique ID
	export PIDFILE
	HERE

      # ROUTE THE REMAINDER OF STDOUT TO THE END OF $txn,
      # overrides any called processes also
      exec >> $txn

      # incorporate environment into transaction
      cat $2

      # generate APPLY part of the transaction
      cat <<-\HERE

	# Quit if a non-zero return code is encountered
	set -e

	case $1 in

	APPLY)

	# Save away the PID of this transaction, so that RESTART can kill it.
	# This would only be the case if RESTART were issued before the
	# APPLY finished (this is not anticipated).
	echo "$0 $$" > $PIDFILE
	set +e
	chmod 666 $PIDFILE 2>/dev/null
	set -e

	HERE

      # generate group entry
      case $node in
	 $MASNODE) ;;	# if this the master node, is already done
	 *)
            cat <<-HERE
		# Add workarea to passwd
		/iDISboot/Ar /iDISboot/AUpw.ss APPLY
		HERE
	    case $Aepw in
		iDISPUBLIC) ;;
		*)
		   cat <<-HERE
			# Add group to /etc/group
			/iDISboot/Ar /iDISboot/AWgrp.ss APPLY
			HERE
		;;
	    esac
	 ;;
      esac

      # see if this is the group's HOME node, if so generate his files
      # unless it is for a GROUP
      case $node in
	 $HomeNode)
	    case $Aepw in
		  GROUP) ;;
		  *)
		     case $Aepw in
		        iDISGROUP) MASK=007 ;;
		        iDISPUBLIC) MASK=000 ;;
		     esac
		     cat <<-HERE
			# set umask so that the group's files are private
			umask $MASK

			# create home directory
			# User directory must be searchable for rje to work
			/iDISboot/Ar /iDISboot/AUhome.ss MKDIR /$HomeFS/$Ausr

			# build common parts of home directory and mail, set ownerships
			cd /$HomeFS/$Ausr
			/iDISboot/Ar /iDISboot/AUhome.ss APPLY
			HERE
		  ;;
	    esac # End case in $Aepw
	 ;;
      esac # End case in $node

      # generate RESTART part of the transaction, and end of APPLY
      cat <<-\HERE
	exit 0
	;;
	RESTART)
	# This is only used to back out transactions that have broken their
	# communications link with the sending node before/during the APPLY
	# part of the transaction.

	# Allow non-zero return codes
	set +e

	# Ensure that a previously running APPLY is killed
	if [ -f $PIDFILE ] ; then
	   set `cat $PIDFILE`
	   CMD=$1 PID=$2
	   ps -e |
	   egrep '^[ 	]*'$PID'[ 	]*.*[ 	]'$CMD'$' >/dev/null 2>&1 &&
	   kill -9 $PID
	fi
	HERE

      # generate group RESTART entry
      case $node in
	 $MASNODE) ;;	# if this the master node, is already done
	 *)
            cat <<-HERE
		# Remove workarea from passwd file
		/iDISboot/Ar /iDISboot/AUpw.ss RESTART
		HERE
	    case $Aepw in
		iDISPUBLIC) ;;
		*)
		   cat <<-HERE
			# Remove group from /etc/group
			/iDISboot/Ar /iDISboot/AWgrp.ss RESTART
			HERE
		;;
	    esac
	 ;;
      esac

      # see if this is the group's HOME node, if so RESTART his files
      case $node in
	 $HomeNode)
	    case $Aepw in
		  GROUP) ;;
		  *)
		     cat <<-HERE
			# Remove group's home directory
			/iDISboot/Ar /iDISboot/AUhome.ss RESTART
			HERE
		  ;;
	    esac
	 ;;
      esac


      # generate tail of transaction
      cat <<-\HERE
	exit 0
	;;

	esac
	HERE
   ;;

   # MODIFY GROUP/WORKAREA
   Mod)
      # We create this type of txn ONLY for groups, NOT for public w/a.
      # That means, Grouptype is always set either to GROUP or iDISGROUP
      # Also, Grouptype is set to iDISGROUP only when we have to create
      # the workarea.
      # ( In R2.0, we don't allow the user to modify public w/a.
      #   However, the necessary logic is there, I think, if public w/a
      #   is allowed to be modified at a later time.)

      # generate header part of the transaction
      cat <<-\HERE > $txn
	: /bin/sh
	# Modify $Kind
	PIDFILE=/tmp/$SNODE.P$TNUM 	# Unique ID
	export PIDFILE
	HERE

      # ROUTE THE REMAINDER OF STDOUT TO THE END OF $txn,
      # overrides any called processes also
      exec >> $txn

      # incorporate environment into transaction
      cat $2

      # generate APPLY part of the transaction
      cat <<-\HERE

	# Quit if a non-zero return code is encountered
	set -e

	case $1 in

	APPLY)

	# Save away the PID of this transaction, so that RESTART can kill it.
	# This would only be the case if RESTART were issued before the
	# APPLY finished (this is not anticipated).
	echo "$0 $$" > $PIDFILE
	set +e
	chmod 666 $PIDFILE 2>/dev/null
	set -e

	HERE

      # modify group entry
      case $node in
	 $MASNODE) ;;	# if this the master node, is already done
	 *)
            cat <<-HERE
		# Modify workarea entry in passwd (Actually, copy the master passwd)
		/iDISboot/Ar /iDISboot/AUpw.ss APPLY
		HERE
	    case $Aepw in
		iDISPUBLIC) ;;
		*)
		   cat <<-HERE
			# Modify group entry in /etc/group
			/iDISboot/Ar /iDISboot/AWgrp.ss APPLY
			HERE
		;;
	    esac
	 ;;
      esac # End case in $node

      # Check whether this txn should create a workarea, if so,
      # see if this is the group's HOME node, if so generate his files
      # unless Grouptype is set to GROUP.
      case $node in
	 $HomeNode)
	    case $Aepw in
		  GROUP) ;;
		  *)
		     case $Aepw in
		        iDISGROUP) MASK=007 ;;
		        iDISPUBLIC) MASK=000 ;;
		     esac
		     cat <<-HERE
			# set umask so that the group's files are private
			umask $MASK

			# create home directory
			# User directory must be searchable for rje to work
			/iDISboot/Ar /iDISboot/AUhome.ss MKDIR /$HomeFS/$Ausr

			# build common parts of home directory and mail, set ownerships
			cd /$HomeFS/$Ausr
			/iDISboot/Ar /iDISboot/AUhome.ss APPLY
			HERE
		  ;;
	    esac # End case in $Aepw
	 ;;
      esac # End case in $node

      # generate RESTART part of the transaction, and end of APPLY
      cat <<-\HERE
	exit 0
	;;
	RESTART)
	# This is only used to back out transactions that have broken their
	# communications link with the sending node before/during the APPLY
	# part of the transaction.

	# Allow non-zero return codes
	set +e

	# Ensure that a previously running APPLY is killed
	if [ -f $PIDFILE ] ; then
	   set `cat $PIDFILE`
	   CMD=$1 PID=$2
	   ps -e |
	   egrep '^[ 	]*'$PID'[ 	]*.*[ 	]'$CMD'$' >/dev/null 2>&1 &&
	   kill -9 $PID
	fi
	HERE

      # generate group RESTART entry
      case $node in
	 $MASNODE) ;;	# if this the master node, is already done
	 *)
            cat <<-HERE
		# Remove workarea from passwd file
		/iDISboot/Ar /iDISboot/AUpw.ss RESTART
		HERE
	    case $Aepw in
		iDISPUBLIC) ;;
		*)
		   cat <<-HERE
			# Remove group from /etc/group
			/iDISboot/Ar /iDISboot/AWgrp.ss RESTART
			HERE
		;;
	    esac
	 ;;
      esac

      # see if this is the group's HOME node, if so RESTART his files
      case $node in
	 $HomeNode)
	    case $Aepw in
		  GROUP) ;;
		  *)
		     cat <<-HERE
			# Remove group's home directory
			/iDISboot/Ar /iDISboot/AUhome.ss RESTART
			HERE
		  ;;
	    esac
	 ;;
      esac

      # generate tail of transaction
      cat <<-\HERE
	exit 0
	;;
      esac
	HERE
    ;;

   # DELETE GROUP/WORKAREA
   Xdel)
      # generate header part of the transaction
      cat <<-\HERE > $txn
	: /bin/sh
	# Initialize $Kind
	PIDFILE=/tmp/$SNODE.P$TNUM 	# Unique ID
	export PIDFILE
	HERE

      # ROUTE THE REMAINDER OF STDOUT TO THE END OF $txn,
      # overrides any called processes also
      exec >> $txn

      # incorporate environment into transaction
      cat $2

      # generate APPLY part of the transaction
      cat <<-\HERE

	# Quit if a non-zero return code is encountered
	set -e

	case $1 in

	APPLY)

	# Save away the PID of this transaction, so that RESTART can kill it.
	# This would only be the case if RESTART were issued before the
	# APPLY finished (this is not anticipated).
	echo "$0 $$" > $PIDFILE
	set +e
	chmod 666 $PIDFILE 2>/dev/null
	set -e

	HERE

      # delete group entry
      case $node in
	 $MASNODE) ;;	# if this the master node, is already done
	 *)
            cat <<-HERE
		# delete workarea from passwd (Actually, copy the master passwd)
		/iDISboot/Ar /iDISboot/AUpw.ss APPLY
		HERE
	    case $Aepw in
		iDISPUBLIC) ;;
		*)
		   cat <<-HERE
			# delete group from  /etc/group
			/iDISboot/Ar /iDISboot/AWgrp.ss APPLY
			HERE
		;;
	    esac
	 ;;
      esac

      # see if this is the group's HOME node, if so delete the files
      # unless it is for a GROUP
      case $node in
	 $HomeNode)
	    case $Aepw in
		  GROUP) ;;
		  *)
		     case $Aepw in
		        iDISGROUP) MASK=007 ;;
		        iDISPUBLIC) MASK=000 ;;
		     esac
		     cat <<-HERE
			# set umask so that the group's files are private
			umask $MASK

			# remove group's home directory
			/iDISboot/Ar /iDISboot/AUhome.ss RESTART 

			HERE
		  ;;
	    esac # End case in $Aepw
	 ;;
      esac # End case in $node

      # generate RESTART part of the transaction, and end of APPLY
      cat <<-\HERE
	exit 0
	;;
	RESTART)
	# This is only used to back out transactions that have broken their
	# communications link with the sending node before/during the APPLY
	# part of the transaction.

	# Allow non-zero return codes
	set +e

	# Ensure that a previously running APPLY is killed
	if [ -f $PIDFILE ] ; then
	   set `cat $PIDFILE`
	   CMD=$1 PID=$2
	   ps -e |
	   egrep '^[ 	]*'$PID'[ 	]*.*[ 	]'$CMD'$' >/dev/null 2>&1 &&
	   kill -9 $PID
	fi
	HERE

      # we don't need to do anything for RESTART of a delete group/workarea txn
      # generate tail of transaction
      cat <<-\HERE
	exit 0
	;;
      esac
	HERE
    ;;

   # INVALID TRANSACTION
   *) echo "$0: Unknown transaction type <$Ttype>" >> $MASSYNCH/logfile
      echo "$0: Unknown transaction type <$Ttype>" >  /dev/console
   ;;
esac
