: 'Copyright 1986 Intel Corp.'
# AUtransb.ss, builds final form user transactions from raw ones
# NOTE: AWtransb.ss is a close companion of this routine.  PLEASE
#	CHECK THERE ALSO WHEN CHANGING THIS ROUTINE.
# Is called with the current directory = $MASSYNCH/$LOGINID.Batch
# 03/15/86 oer
# 03/30/86 oer misc. cleanup
# 04/08/86 oer copy passwd file for each batch
# 05/02/86 oer change the way standalone systems are handled, to reduce errors.
# 05/08/86 oer change to reference the master node
# 07/02/86 oer add Atsplit, to get away from number of open file problems w/ awk

MASSYNCH=$MASNODEP`$iDISBIN/Unonode $iDIS`/synch # Master node synch directory
export MASSYNCH

if [ -f $MASSYNCH/debug ] ; then
	set -x
	echo $0
fi

idisN=/usr/tmp/AUi$$
xenixN=/usr/tmp/AUx$$
xoN=/usr/tmp/AUxo$$
# traps to ignore 1 and 2 have been set previously
trap "rm -f $idisN $xenixN $xoN; trap 0; exit" 0 3 15

RAW=./$LOGINID.idisU

# See if there are any transactions to process
if egrep '^#\(' $RAW > /dev/null 2>&1 ; then
	: O.K., some exist to process
else
	exit 0
fi

# split the raw transactions into individual files (T.n)
# We might have restarted from /etc/rc, so remove any existing T.n files
rm -f T.*
$iDISBIN/Atsplit < $RAW

# get list of iDIS Execution nodes and XENIX nodes.
# for standalone systems, there is only the single iDIS node to worry about
case $OPENNET in
   n)
      echo $MASNODE > $idisN
   ;;

   y)
      $iDISBIN/Uselect -s \: 2 1 idis < /etc/drm/finder.rsrc | sort -u > $idisN
      $iDISBIN/Axnodes.ss > $xenixN

      # get list of nodes that are XENIX nodes, but not iDIS nodes
      comm -23 $xenixN $idisN > $xoN

      # for each XENIX-only node do required actions
      for node in `cat $xoN`
      do
         [ -d $node.work ] || mkdir $node.work
         # generate a txn to copy master passwd and resource assignment file
	 case $node in
	    $MASNODE) ;;	# if this is the master node, already done
	    *)
	       (
	       cd $node.work
	       $iDISBIN/AUnodeb.ss passwd $node ../T.1
	       $iDISBIN/AUnodeb.ss assign $node ../T.1
	       )	# use the first transaction, to provide an environment
	    ;;
	 esac

	 for trans in `ls T.*`
	 do
	    (
	       cd $node.work
	       $iDISBIN/AUnodeb.ss xenix $node ../$trans
	    )
	 done
      done
   ;;
esac

# for each iDIS execution node do required actions
for node in `cat $idisN`
do
   [ -d $node.work ] || mkdir $node.work
   # generate a transaction to copy master passwd and resource assignment file
   case $node in
      $MASNODE) ;;	# if this is the master node, already done
      *)
	 (
	 cd $node.work
	 $iDISBIN/AUnodeb.ss passwd $node ../T.1
	 $iDISBIN/AUnodeb.ss assign $node ../T.1
	 )	# use the first transaction, to provide an environment
      ;;
   esac

   for trans in `ls T.*`
   do
      (
	 cd $node.work
	 $iDISBIN/AUnodeb.ss idis $node ../$trans
      )
   done
done

exit 0
