:
# "Adelnode.ss", a shell script to delete a node from the sub-network.

# Copyright 1986 Intel Corporation.

# 04/27/86  gll  Written for iDIS R2.0.
# 05/22/86  gll  Revised to correct permissions on system files
#                after editing out node entries.  Also, now removes
#                the /usr/iDIS/synch/<node>.apply directory from
#                the master node.
# 06/27/86  gll  Modified updates of finder files to correct
#                permissions and ownerships afterwards.
# 07/02/86  gll  SPR 202.  Modified to make sure only user and
#                execution nodes belonging to the subnetwork can be
#                deleted.
# 09/02/86  ugg  Modified to make sure that no user is logged in and
#                also perform more cleanup so that the node is totally
#                invisible to the sub-net.
# 09/23/86  ugg  modified to get the latest list of valid node names.

# Make sure the node is currently there.

if [ $# -eq 0 ]
then echo "
You did not specify a node to delete."
     exit 1
fi

node=$1
$iDISBIN/ALxnodes.ss
# Make sure only user and execution nodes belongiong to this subnet
# can be deleted.

if [ "$node" != "$MASNODE" ]
then if [ `grep -c "$node" $iDIS/legals/Lxnodes` -eq 0 ]
     then echo "
Node $node is not a user or execution node in Sub-Network $MASNODE,
and therefore cannot be deleted."
          exit 1
     fi
else echo "
Node $node is the Sub-Network master node, and therefore cannot be
deleted."
     exit 1
fi

if [ `grep -c "^$node/" $MASNODEP/net/data` = 0 ]
then echo "
Could not find node $node."
     exit 1
fi

#  First make sure that no one is physically logged in to the node.
count=`who | sed -e "s/^\(.........\)\([^ ]*\).*$/\2/" | grep -c "^$node$"`
#
if [ $count -gt 0 ] ; then
   echo "\nThere are users logged in to node $node."
   echo "You can not delete a node when users are logged in to it."
   exit 1
fi
# remove the network information from remote node's network files.
grep "^$node/" //$node/net/data > //$node/net/data.$$
mv //$node/net/data.$$ //$node/net/data
grep "^$node:" //$node/net/cdf > //$node/net/cdf.$$
mv //$node/net/cdf.$$ //$node/net/cdf
#
#  disable nfs nfc, so that any active vc will be disconnected.
rexec //$node/etc/nfc off -- /dev/null
rexec //$node/etc/nfs off -- /dev/null
# Remove node from /net/data and /net/cdf

sed -e /$node/d $MASNODEP/net/data > $MASNODEP/net/data.tmp
cp $MASNODEP/net/data.tmp $MASNODEP/net/data
rm -f $MASNODEP/net/data.tmp
chmod 644 $MASNODEP/net/data
sed -e /$node/d $MASNODEP/net/cdf > $MASNODEP/net/cdf.tmp
cp $MASNODEP/net/cdf.tmp $MASNODEP/net/cdf
rm -f $MASNODEP/net/cdf.tmp
chmod 644 $MASNODEP/net/cdf

# Remove node from DRM files

sed -e /$node/d $MASNODEP/etc/drm/finder.rsrc > $MASNODEP/etc/drm/finder.tmp
cp $MASNODEP/etc/drm/finder.tmp $MASNODEP/etc/drm/finder.rsrc
chmod 664 $MASNODEP/etc/drm/finder.rsrc
chgrp 800 $MASNODEP/etc/drm/finder.rsrc
chown 800 $MASNODEP/etc/drm/finder.rsrc
rm -f $MASNODEP/etc/drm/finder.tmp
sed -e /$node/d $MASNODEP/etc/drm/finder.assign > $MASNODEP/etc/drm/finder.tmp
cp $MASNODEP/etc/drm/finder.tmp $MASNODEP/etc/drm/finder.assign
chmod 664 $MASNODEP/etc/drm/finder.assign
chgrp 800 $MASNODEP/etc/drm/finder.assign
chown 800 $MASNODEP/etc/drm/finder.assign
rm -f $MASNODEP/etc/drm/finder.tmp

# Remove the nodes users and groups

for name in `$iDISBIN/Uselect -es : 0 5 "..$node[.]*" < $MASNODEP/etc/passwd`
do
   # Delete from Personnel directory

   ed $MASNODEP/etc/Personnel <<-HERE > /dev/null
	/^$name
	.,+2d
	w $MASNODEP/etc/Personnel
	q
	HERE
   chmod 664 $MASNODEP/etc/Personnel

   # Delete from group file

   ed $MASNODEP/etc/group <<-HERE > /dev/null
	/^$name/d
	w $MASNODEP/etc/group
	q
	HERE
   chmod 644 $MASNODEP/etc/group

   # Delete from password file

   ed $MASNODEP/etc/passwd <<-HERE > /dev/null
	/^$name/d
	w $MASNODEP/etc/passwd
	q
	HERE
   chmod 644 $MASNODEP/etc/passwd

done

# Delete the nodes net synch directory

rm -rf $MASNODEP/usr/iDIS/synch/$node.apply

# All done.
