: 'Copyright 1986 Intel Corporation.'
# saves a workarea
# 07/16/86 oer add lock logic

if [ $CURDEV != "unassigned" ]; then
	curtype=`Uselect -s : 1 0 $CURDEV < /etc/drm/finder.rsrc`
	blocking="`Uselect -s : 1 0 $curtype \
				< /etc/drm/finder.usage | tr ';' ' '`"
	device=`Uselect -s : 3 0 $CURDEV < /etc/drm/finder.rsrc`
else
	echo "\n Current device is unassigned.\n"\
		"Choose \"chng\" from menu to select a device for save/restore."
	exit 1
fi

if [ "$OPENNET" = "y" ]; then
	nodename=`Uselect -s : 2 0 $CURDEV < /etc/drm/finder.rsrc`
	devnode=//$nodename
	echo " You are using the $CURDEV device" \
		"on node $nodename"
else
	devnode=""
	echo " You are using the $CURDEV device " 
fi
##############
NOTALLOWED="The work area selected is not on a node which you are allowed to administer."
AUTH=`Aauthority.ss $LOGINID`
case $AUTH in
	keyoperator)
		NODELIST=`Argetnodes.ss $LOGINID keyoperator | tr '\012' ' '`
		ASK=yes
	;;
	lognetadmin|subnetadmin)
		ASK=yes
	;;
	*)
		ASK=no
	;;
esac

if [ "$ASK" = "yes" ]; then 
PASS=/etc/passwd
OP=save
if [ "$OPENNET" = "y" ]; then
	echo -n \
	"\n Current work area is the $WATYPE work area on the $WORKSYS node.\n"
else
	echo -n \
	"\n Current work area is the $WATYPE work area.\n"
fi
while [ TRUE ] ; do
echo -n "\n Please enter the type of work area which you want to $OP\n"\
			"(c=current i=individual g=group p=public): "
read RESP
case $RESP in 
	c*)	break
	;;
	i*)	echo -n "\n Please enter the loginid of the user"\
			"\n whose work area you want to $OP: "
		read ID
		if [ "$ID" != "" ]; then
		NEWHOME=`Uselect -s : 5 0 $ID < $PASS`
		if [ "$NEWHOME" != "" ]; then
			if [ "$AUTH" = "keyoperator" ]; then
				echo $NODELIST |
				egrep `Ustripnode $NEWHOME` > /dev/null
				case $? in
					0) 	HOME=$NEWHOME
						break
					;;
					*)	if [ "$OPENNET" = "y" ]; then
							echo "\n $NOTALLOWED"
						else
							HOME=$NEWHOME
							break
						fi
					;;
				esac
			else
				HOME=$NEWHOME
				break
			fi
		else 
			echo "\n $ID is not a valid login.\n"
		fi
		fi
	;;
	g*)	echo -n "\n Please enter the name of the group work"\
			"area you want to $OP: "
		read ID
		if [ "$ID" != "" ]; then
		NEWHOME=`Uselect -s : 5 0 $ID < $PASS`
		if [ "$NEWHOME" != "" ]; then
			if [ "$AUTH" = "keyoperator" ]; then
				echo $NODELIST |
				egrep `Ustripnode $NEWHOME` > /dev/null
				case $? in
					0) 	HOME=$NEWHOME
						break
					;;
					*)	if [ "$OPENNET" = "y" ]; then
							echo "\n $NOTALLOWED"
						else
							HOME=$NEWHOME
							break
						fi
					;;
				esac
			else
				HOME=$NEWHOME
				break
			fi
		else 
			echo "\n $ID is not a valid group workarea.\n"
		fi
		fi
	;;
	p*)	echo -n "\n Please enter the name of the"\
			"public work area you want to $OP: "
		read ID
		if [ "$ID" != "" ]; then
		NEWHOME=`Uselect -s : 5 0 $ID < $PASS`
		if [ "$NEWHOME" != "" ]; then
			if [ "$AUTH" = "keyoperator" ]; then
				echo $NODELIST |
				egrep `Ustripnode $NEWHOME` > /dev/null
				case $? in
					0) 	HOME=$NEWHOME
						break
					;;
					*)	if [ "$OPENNET" = "y" ]; then
							echo "\n $NOTALLOWED"
						else
							HOME=$NEWHOME
							break
						fi
					;;
				esac
			else
				HOME=$NEWHOME
				break
			fi
		else 
			echo "\n $ID is not a valid public workarea.\n"
		fi
		fi
	;;
esac
done
fi

# name of the lock file
LOCK=$devnode/tmp/$CURDEV

# see if the device is in use
if [ -f $LOCK ] ; then
   set `cat $LOCK`
   menuid=$1
   owner=$2
   case $menuid in
      $MENUID) ;;	# It is us, everything is o.k.
      *)
	  echo "
 It is possible that the $CURDEV drive is in use by someone else.  Our
 information suggests that it is in use by a user whose login ID is $owner.
 It is recommended that you physically examine the drive to determine if it is
 in fact being used.

 You will be given an opportunity to go ahead with this operation.  If you
 do go ahead, and the $CURDEV drive IS in use it is possible that you will
 destroy any data that exists on $owner's media.\n"

	  while :
	  do
	      echo -n " Do you wish to go ahead with this operation (y or n)? "
	      read resp
	      case $resp in
		y*|Y*)	rm -f $LOCK
			break ;;
		n*|N*)	echo " Operation has been canceled."
			exit 1 ;;
		*)	echo "\n Invalid response <$resp>, please respecify"
	      esac
	  done
      ;;
   esac
fi

# remove lock when script exits (normally or abnormally)
trap "rm -f $LOCK; trap 0; exit" 0 1 2 3 15

# reserve the device
echo "$MENUID $LOGINID" > $LOCK
chmod 666 $LOCK

cd $HOME
case $curtype in

	5-in-diskette|8-in-diskette)
	case $curtype in 
		5-in-diskette)	volsize=360
		;;
		8-in-diskette)	volsize=1200
		;;
	esac
	echo -n " Do you want an estimate of the number of diskettes needed?"\
				" (y or n) "
	read resp
	if [ "$resp" = "y" ];then
		Aasavev.ss $volsize diskette
	fi
	echo -n " Do you want to format your diskettes? (y or n) "
	read resp
	if [ "$resp" = "y" ];then
		Aasavef.ss	
	fi
	echo "\n Ready to save the workarea now."
	echo -n " Please insert a formatted diskette.\n" \
	     	"Press return when ready."
	read x
	tar cnvfbk $devnode$device $blocking .
	;;

	directory)
	again=yes
	while :
	do
		echo -n " Please type name you want to use"\
			"for your archive: "
		read filename
		if Fnamck $filename ; then
			if [ -f $devnode/$device/$filename ]; then
				set -- `l $devnode/$device/$filename`
				OWNER=$3
				if [ "$OWNER" = "$LOGINID" ]; then
					echo " An archive by this name already exists."
					echo -n " Do you want to over-write it? (y or n) "
					read resp
					case $resp in
						y) ;;
						*) continue ;;
					esac
				else
					echo " An archive by this name already exists."
					continue
				fi
			fi
			echo -n " Ready to begin saving the workarea.\n"\
				"Press return to start."
				read x
			break
		else
		    	echo "\n Archive name must be at most 14 chars,"\
				"consisting of:\n"\
		      		"	letters, numbers, period, "\
				"underscore and hyphen\n"
		     	continue
		fi
	done
	tar cvf $devnode/$device/$filename .
	chown $LOGINID $devnode/$device/$filename
	;;

	streamertape)
	again=yes
	while [ "$again" = "yes" ]
	do
		echo -n " Please enter the size cartridges you will use: "\
			"(40mb or 60mb) "
		read num
		case $num in
			4|40|40mb|40MB)	again=no
				volsize=40000
			;;
			6|60|60mb|60MB)	again=no
				volsize=60000
			;;
		esac
	done
	echo -n " Do you want an estimate of the number of tapes needed?"\
				" (y or n) "
	read resp
	if [ "$resp" = "y" ];then
		Aasavev.ss $volsize tape
	fi
	echo -n " Do you want to retension your tape cartridges? (y or n) "
	read resp
	if [ "$resp" = "y" ];then
		Aasavert.ss	
	fi
	echo "\n Ready to save the workarea now."
	echo -n " Please insert the first tape cartridge.\n Press return when ready. "
	read x
	if [ "$OPENNET" = "y" ]; then
		pwd=`pwd`
		COMMAND="/bin/tar cvfbk $device 20 $volsize . "
		/iDISboot/Aartar.ss "${COMMAND}" //$WORKSYS`Unonode $pwd` $nodename
	else
		tar cvfbk $device 20 $volsize .
	fi
	;;

	9tracktape)
	while [ TRUE ]
	do
		echo -n "\n Please enter the length "\
			"of the tape reels you will use (in feet): "
		read length
		if [ "`Aanumeric.ss $length`" ]; then
			density=19200
			volsize=`expr $length \* $density / 1024`
			break
		else
			echo "\n $length is not a numeric value.\n"
		fi
	done
	echo -n " Do you want an estimate of the number of tape reels needed?"\
				" (y or n) "
	read resp
	if [ "$resp" = "y" ];then
		Aasavev.ss $volsize tape
	fi
	echo "\n Ready to save the workarea now."
	echo -n " Please insert the first tape reel.\n Press return when ready. "
	read x
	if [ "$OPENNET" = "y" ]; then
		pwd=`pwd`
		COMMAND="/bin/tar cvfbk $device 20 $volsize . "
		/iDISboot/Aartar.ss "${COMMAND}" //$WORKSYS`Unonode $pwd` $nodename
	else
		tar cvfbk $device 20 $volsize .
	fi
	;;

esac
