: 'Copyright 1986 Intel Corp.'
# Build transactions for a target node
# NOTE: There is a companion script to this AWnodeb.ss
# PLEASE KEEP THEM IN SYNCH, AS REQUIRED
# 03/15/86 oer
# 03/27/86 gll  Corrected syntax error PIDFILE], AUhome==>AUhome.ss
# 03/30/86 oer misc. cleanup
# 04/02/86 oer improve menu system handling
# 04/04/86 oer add delete user
# 04/08/86 oer change passwd generation, will be done for the entire batch
# 04/20/86 oer add rsrc assign propagation, will be done for the entire batch
# 04/21/86 oer change individual umask, so FM will work
# 04/27/86 oer change individual umask back, need to decide on user-to-user copy
# 05/08/86 oer change to reference the master node
# 05/28/86 oer make PIDFILE 666, prevents problem when 1st trans. is deferred
# 05/30/86 oer make sure files are valid & properly owned (don't cp)
# 06/25/86 oer only generate a finder.cur if one exists (so lpr msg wont appear)
# 07/03/86 oer clarify recovery actions if a menu system isn't located
# 07/08/86 oer add check to make sure template still exists
# 07/21/86 oer give error msg if user directory exists
# 07/27/86 dan added ;; esac to fix case down in trx.003

MASSYNCH=$MASNODEP`$iDISBIN/Unonode $iDIS`/synch # Master node synch directory
export MASSYNCH

if [ -f $MASSYNCH/debug ] ; then
	set -x
	echo $0
fi

nodetype=$1	# idis, xenix, assign, or passwd
node=$2
. $3		# set up environment


txn=$node.`$iDISBIN/Anxtxn $node`	# get next transaction number

case $Ttype in
   # INVALID TRANSACTION
   Init) ;;
   Mod) ;;
   Xdel) ;;
   *) echo "$0: Unknown transaction type <$Ttype>" >> $MASSYNCH/logfile
      echo "$0: Unknown transaction type <$Ttype>" >  /dev/console
      exit 1
   ;;
esac

# -------   COPY PASSWD   -----------------------------------------------
# see if this is the request to copy the master passwd
case $nodetype in
   passwd)
      # generate header part of the transaction
      cat <<-\HERE > $txn
	: /bin/sh
	# Copy master passwd
	PIDFILE=/tmp/$SNODE.P$TNUM 	# Unique ID
	export PIDFILE
	# Ignore the following info., only needed for a minimal environment
	HERE

      # ROUTE THE REMAINDER OF STDOUT TO THE END OF $txn,
      # overrides any called processes also
      exec >> $txn

      # incorporate environment into transaction, could be any user trans.
      cat $3

      # generate APPLY part of the transaction
      cat <<-\HERE

	# Quit if a non-zero return code is encountered
	set -e

	case $1 in

	APPLY)

	# Save away the PID of this transaction, so that RESTART can kill it.
	# This would only be the case if RESTART were issued before the
	# APPLY finished (this is not anticipated).
	echo "$0 $$" > $PIDFILE
	set +e
	chmod 666 $PIDFILE 2>/dev/null
	set -e

	# copy master /etc/passwd
	set +e
	while :
	do
	   /iDISboot/Ar /iDISboot/AUpw.ss APPLY
	   case \$? in
	      201) sleep 5;;	# files aren't available
	      202) set -e
	         echo Problem in accessing /etc/passwd
	         exit 1 ;;
	      *)   break  ;;
	   esac
	done
	set -e

	HERE
      # generate RESTART part of the transaction, and end of APPLY
      cat <<-\HERE
	exit 0
	;;

	RESTART)
	# This is only used to back out transactions that have broken their
	# communications link with the sending node before/during the APPLY
	# part of the transaction.

	# Allow non-zero return codes
	set +e

	# Ensure that a previously running APPLY is killed
	if [ -f $PIDFILE ] ; then
	   set `cat $PIDFILE`
	   CMD=$1 PID=$2
	   ps -e |
	   egrep '^[ 	]*'$PID'[ 	]*.*[ 	]'$CMD'$' >/dev/null 2>&1 &&
	   kill -9 $PID
	fi
	HERE
      # generate tail of transaction
      cat <<-\HERE
	# Don't need to do anything
	exit 0
	;;

	esac
	HERE
      exit 0
   ;;
esac

# -------   COPY RESOURCE ASSIGNMENT   ----------------------------------
# see if this is the request to copy the master assignment file
case $nodetype in
   assign)
      # generate header part of the transaction
      cat <<-\HERE > $txn
	: /bin/sh
	# Copy master assignment file
	PIDFILE=/tmp/$SNODE.P$TNUM 	# Unique ID
	export PIDFILE
	# Ignore the following info., only needed for a minimal environment
	HERE

      # ROUTE THE REMAINDER OF STDOUT TO THE END OF $txn,
      # overrides any called processes also
      exec >> $txn

      # incorporate environment into transaction, could be any user trans.
      cat $3

      # generate APPLY part of the transaction
      cat <<-\HERE

	# Quit if a non-zero return code is encountered
	set -e

	case $1 in

	APPLY)

	# Save away the PID of this transaction, so that RESTART can kill it.
	# This would only be the case if RESTART were issued before the
	# APPLY finished (this is not anticipated).
	echo "$0 $$" > $PIDFILE
	set +e
	chmod 666 $PIDFILE 2>/dev/null
	set -e

	# copy master /etc/drm/finder.assign
	copy -o $MASNODEP/etc/drm/finder.assign /etc/drm/cp$$
	mv /etc/drm/cp$$ /etc/drm/finder.assign

	HERE
      # generate RESTART part of the transaction, and end of APPLY
      cat <<-\HERE
	exit 0
	;;

	RESTART)
	# This is only used to back out transactions that have broken their
	# communications link with the sending node before/during the APPLY
	# part of the transaction.

	# Allow non-zero return codes
	set +e

	# Ensure that a previously running APPLY is killed
	if [ -f $PIDFILE ] ; then
	   set `cat $PIDFILE`
	   CMD=$1 PID=$2
	   ps -e |
	   egrep '^[ 	]*'$PID'[ 	]*.*[ 	]'$CMD'$' >/dev/null 2>&1 &&
	   kill -9 $PID
	fi
	HERE
      # generate tail of transaction
      cat <<-\HERE
	# Don't need to do anything
	exit 0
	;;

	esac
	HERE
      exit 0
   ;;
esac

# -------   INITIALIZE USER   -------------------------------------------
case $Ttype in
   # INITIALIZE USER
   Init)
      # generate header part of the transaction
      cat <<-\HERE > $txn
	: /bin/sh
	# Initialize User
	PIDFILE=/tmp/$SNODE.P$TNUM 	# Unique ID
	export PIDFILE
	HERE

      # ROUTE THE REMAINDER OF STDOUT TO THE END OF $txn,
      # overrides any called processes also
      exec >> $txn

      # incorporate environment into transaction
      cat $3



      # generate APPLY part of the transaction
      cat <<-\HERE

	# Quit if a non-zero return code is encountered
	set -e
	HERE

      # double check that the template exists, the user could have deleted it
      # before applying the transaction.  This is such a rare case the error
      # reporting will be somewhat of a kludge, a syntax error.
      if [ ! -d $MASNODEP/etc/Templates/$Template ] ; then
	 cat <<-HERE
: "The template used to create this user, $Template, no longer exists.  It was"
: "deleted prior to the activation of this transaction.  You need to delete"
: "this user ($Ausr) and reinitialize him.  You must either re-create the"
: "$Template template OR use another template in the user reinitalization."
ERROR!!! ERROR!!!
	HERE
	 exit 0
      fi

      cat <<-\HERE
	case $1 in

	APPLY)

	# Save away the PID of this transaction, so that RESTART can kill it.
	# This would only be the case if RESTART were issued before the
	# APPLY finished (this is not anticipated).
	echo "$0 $$" > $PIDFILE
	set +e
	chmod 666 $PIDFILE 2>/dev/null
	set -e

	HERE



      # if this is an idis node, generate login info.
      case $nodetype in
	 idis)
	    # For each menu system, get info., substituting user name
	    cd $MASNODEP/etc/Templates/$Template/menusystems
	    for ms in `ls`
	    do
	       cat <<-HERE

		# Add user to menu system
		if [ ! -d `cat $ms/path`/control ] ; then
		   cat <<HERE@@ | mail -s "$ms menu system not present on node \$NODE" \$LOGIN
The $ms menu system was not present on node \$NODE.
An attempt was made to add user \$Ausr to this menu system.  This attempt
was part of batch \` expr \$BATCH + 0\`.  The remainder of user \$Ausr's transaction IS
proceeding.  The user will be added to other existing menu systems.

If the $ms menu system is added to node \$NODE at sometime in the
future, you will need to add user \$Ausr to the menu system's login table.
This is done via the iMENU feature (you will also need to perform the iMENU
'af' function after the login table has been updated).  An alternative
approach is to delete the user \$Ausr, add the $ms menusystem to node
\$NODE, and once more add user \$Ausr.
		HERE@@

		   else
		cd `cat $ms/path`/control
		cat <<\HERE@@ >> /tmp/deauth.\$\$
		HERE
	       sed -e 's/loginID/'$Ausr'/' $ms/deauth.dat
	       cat <<-HERE
		HERE@@
		cat <<\HERE@@ >> /tmp/login.\$\$
		HERE
	       sed -e 's/loginID/'$Ausr'/' $ms/login.dat
	       cat <<-HERE
		HERE@@
		set +e
		# Update the target menu system, detecting any errors
		/iDISboot/AUaf.ss APPLY $ms /tmp/login.\$\$ /tmp/deauth.\$\$
		rm -f /tmp/login.\$\$ /tmp/deauth.\$\$
		set -e

		cat <<\\HERE@@ >> $Ausr.pro
		HERE
		sed -e 's/loginID/'$Ausr'/' $ms/login.pro
	       cat <<-HERE
		HERE@@
		fi
		HERE

	    done
	 ;; # end of idis)
      esac



      # see if this is the user's HOME node and a new user,
      # if so generate his files
      case $node in
	 $HomeNode)
	    cat <<-HERE
		# set umask so that the user's files are private, but will
		# allow File Management to copy files.  This is for directories,
		# files are still 700.
		umask 077	# 044 if user-to-user copy desired

		# create home directory
		# User directory must be searchable for rje to work
		case $Olduser in
		   no) if [ -d /$HomeFS/$Ausr ] ; then
		          cat <<HERE@@ | mail -s "A directory already exists for user $Ausr on node \$NODE" \$LOGIN
A directory, /$HomeFS/$Ausr, already exists on node \$NODE.  This name was
chosen for $Ausr's home directory.  As a result it was not possible to 
complete the initialization of $Ausr.  In order to successfully initialize
$Ausr you will need to choose a directory name that does not exist.

First, you will need to delete $Ausr from the system.  HOWEVER, the normal
user deletion process will need to be 'fooled' into thinking that $Ausr's
home directory is someplace other than /$HomeFS/$Ausr.  If you try and
delete $Ausr now the /$HomeFS/$Ausr directory will be removed.  This is NOT
what you want to do.  To 'fool' the deletion process, change the master
/etc/passwd entry for $Ausr to reference a non-existent home directory
(e.g., /xyz/home).

Once $Ausr has been deleted from the system he can be re-initialized.
This time with a unique home directory name.
			HERE@@
: "The home directory for user $Ausr, /$HomeFS/$Ausr, already exists."
: "Please refer to your mail for an explanation of what occurred and what"
: "must be done to successfully initialize user $Auser."
ERROR!!! ERROR!!!
		       fi
		   ;;
      		esac

		/iDISboot/Ar /iDISboot/AUhome.ss MKDIR /$HomeFS/$Ausr
		cd /$HomeFS/$Ausr
		HERE

	    # generate the Template unique parts of his home directory
	    cd $MASNODEP/etc/Templates/$Template
	    for file in profile login cshrc mailrc
	    do
	       echo "cat <<\HERE@@ > .$file"
	       cat $file
	       echo "HERE@@"
	    done

	    if [ -f finder.cur ] ; then
	       echo "cat <<\HERE@@ > .finder.cur"
	       cat finder.cur
	       echo "HERE@@"
	    fi

	    cat <<-HERE
		# build common parts of home directory and mail, set ownerships
		cd /$HomeFS/$Ausr
		/iDISboot/Ar /iDISboot/AUhome.ss APPLY
		HERE
	 ;;
      esac



      # generate RESTART part of the transaction, and end of APPLY
      cat <<-\HERE
	exit 0
	;;

	RESTART)
	# This is only used to back out transactions that have broken their
	# communications link with the sending node before/during the APPLY
	# part of the transaction.

	# Allow non-zero return codes
	set +e

	# Ensure that a previously running APPLY is killed
	if [ -f $PIDFILE ] ; then
	   set `cat $PIDFILE`
	   CMD=$1 PID=$2
	   ps -e |
	   egrep '^[ 	]*'$PID'[ 	]*.*[ 	]'$CMD'$' >/dev/null 2>&1 &&
	   kill -9 $PID
	fi
	HERE



      # if this is an idis node, remove login info.
      case $nodetype in
	 idis)
	    # For each menu system, get info., substituting user name
	    cd $MASNODEP/etc/Templates/$Template/menusystems
	    for ms in `ls`
	    do
	       cat <<-HERE
		# Remove user's menu system info.
		if [ -d `cat $ms/path`/control ] ; then
		   cd `cat $ms/path`/control
		   /iDISboot/AUaf.ss RESTART $ms
		fi
		HERE
	    done
	 ;; # end of idis)
      esac



      # see if this is the user's HOME node and a new user,
      # if so RESTART his files
      if  [ "$node" = "$HomeNode" -a "Olduser" = no ] ; then
	 cat <<-HERE
		# Remove user's home directory and mail file
		/iDISboot/Ar /iDISboot/AUhome.ss RESTART
		HERE
      fi


      # generate tail of transaction
      cat <<-\HERE
	exit 0
	;;

	esac
	HERE
      exit 0
   ;;
esac

# -------   MODIFY USER   -----------------------------------------------
case $Ttype in
   # MODIFY USER
   Mod) ;;
esac

# -------   DELETE USER   -----------------------------------------------
case $Ttype in
   # DELETE USER
   Xdel)
      # generate header part of the transaction
      cat <<-\HERE > $txn
	: /bin/sh
	# Delete User
	PIDFILE=/tmp/$SNODE.P$TNUM 	# Unique ID
	export PIDFILE
	HERE

      # ROUTE THE REMAINDER OF STDOUT TO THE END OF $txn,
      # overrides any called processes also
      exec >> $txn

      # incorporate environment into transaction
      cat $3

      # generate APPLY part of the transaction
      cat <<-\HERE

	# Quit if a non-zero return code is encountered
	set -e

	case $1 in

	APPLY)

	# Save away the PID of this transaction, so that RESTART can kill it.
	# This would only be the case if RESTART were issued before the
	# APPLY finished (this is not anticipated).
	echo "$0 $$" > $PIDFILE
	set +e
	chmod 666 $PIDFILE 2>/dev/null
	set -e

	# Remove user's home directory and mail file (might not exist on
	# this node)
	/iDISboot/Ar /iDISboot/AUhome.ss RESTART

	HERE



      # If master node remove the user's Personnel directory entry
      case $node in
	 $MASNODE)
	    cat <<-HERE
		# Remove user from personnel directory
		set +e 
		$iDISBIN/AUdirx $Ausr
		set -e 

		HERE
	 ;; # end of $MASNODE)
      esac



      # if this is an idis node, remove login info.
      case $nodetype in
	 idis)
	    # For each menu system that I know about, remove the user
	    cd $MASNODEP/etc/Templates
	    for ms in `ls -d */menusystems/* | sort -ut/ +2`
	    do
	       cat <<-HERE

		# Remove user from menu system
		if [ -d `cat $ms/path`/control ] ; then
		   cd `cat $ms/path`/control
		   set +e 
		   # Update the target menu system
		   /iDISboot/AUaf.ss RESTART `basename $ms`
		   set -e
		   rm -f $Ausr.pro
		fi
		HERE

	    done
	 ;; # end of idis)
      esac



      # generate RESTART part of the transaction, and end of APPLY
      cat <<-\HERE
	exit 0
	;;

	RESTART)
	# This is only used to back out transactions that have broken their
	# communications link with the sending node before/during the APPLY
	# part of the transaction.

	# Allow non-zero return codes
	set +e

	# Ensure that a previously running APPLY is killed
	if [ -f $PIDFILE ] ; then
	   set `cat $PIDFILE`
	   CMD=$1 PID=$2
	   ps -e |
	   egrep '^[ 	]*'$PID'[ 	]*.*[ 	]'$CMD'$' >/dev/null 2>&1 &&
	   kill -9 $PID
	fi
	;;

	# no need to do anything for restart
	esac
	HERE
   ;;
esac
