#!/usr/bin/perl -w
#!/usr/local/bin/perl -w

use FileHandle;

my $buf;
my @buf = ();
my $chk = 0;

# read 128x8 binary image, transfrom to 256x4 binary image
my $INP = FileHandle->new("<".$ARGV[0]);
my $BIN = FileHandle->new(">".$ARGV[1]);
while (read($INP, $buf, 1)) {
    my $hi = (ord($buf)>>4)&0xF;  print $BIN pack('C', $hi);  $chk += $hi;  push(@buf, $hi);
    my $lo = (ord($buf)>>0)&0xF;  print $BIN pack('C', $lo);  $chk += $lo;  push(@buf, $lo);
}
close($INP);
close($BIN);

# rename file with hex checksum in name
$chk = sprintf("%04X", $chk&0xFFFF);
(my $final = $ARGV[1]) =~ s/XXXX/$chk/e;
rename($ARGV[1], $final);


# compute checksum (twos complement of the sum of bytes)
sub chksum (@) { my $sum = 0; map($sum += $_, @_); return (-$sum) & 0xFF; }

my $bytesper = 16;
my $romsize = scalar(@buf);

# output the entire PROM buffer as an intel hex file
(my $hexfile = $final) =~ s/[.][a-z]+$/.hex/;
my $HEX = FileHandle->new(">".$hexfile);
for (my $idx = 0; $idx < $romsize; $idx += $bytesper) {
    my $cnt = $idx+$bytesper <= $romsize ? $bytesper : $romsize-$idx;
    my @dat = @buf[$idx..($idx+$cnt-1)];
    my $dat = join('', map(sprintf("%02X",$_),@dat));
    printf $HEX ":%02X%04X%02X%s%02X\n", $cnt, $idx, 0x00, $dat, &chksum($cnt, $idx>>0, $idx>>8, 0x00, @dat);
}
printf $HEX ":%02X%04X%02X%s%02X\n", 0x00, 0x0000, 0x01, '', &chksum(0x0, 0x0000>>0, 0x0000>>8, 0x01);
close($HEX);

exit;

# the end
