PAGE	55,132
.SALL
NAME	LOGON
TITLE	LOGON - SHELL PROGRAM TO TEST LOGON.INC

IF2
	%OUT	<Starting Pass Two>
ENDIF

;**************************************************************************
;
;	LOGON -- SHELL PROGRAM TO TEST LOGON.INC
;	(c) Copyright 1984 Corvus Systems, Inc.
;
;**************************************************************************
;		R E V I S I O N    H I S T O R Y
;
;	1.01  10-24-84	original version (WEK)
;	1.02  11-27-84	added this history record and removed system
;			dependency by referencing the SYSTEM.EQU
;			include file. (BRK)
;	1.03	WILLIAM E. KLINE - 06-Feb-85
;		1. Added support for version 4.06 of LOGON.INC
;		   - added DVRTYP
;
; NOTE: if changes are made, include a note in this history record and
;	increment the appropriate version # equates ( VER, REV, & SUBREV).
;**************************************************************************

CODE	SEGMENT PARA PUBLIC 'CODE'

	ASSUME	CS:CODE,DS:CODE,ES:CODE

	ORG	100H			;
START:	JMP	MAIN			;

;**************************************************************************
;
; EQUATES
;
;**************************************************************************

VER	EQU	1			;
REV	EQU	0			;
SUBREV	EQU	2			;

CORVER	EQU	6			;
CORREV	EQU	0			;

TRUE	EQU	0FFFFH			;
FALSE	EQU	0			;
;
;SHADOW Drive equates
DT_OFFLINE	EQU    -1
DT_NORMAL	EQU	0
DT_MASTER	EQU	1
DT_SLAVE	EQU	2
NO_SHADOW_PROM	EQU	3

DM_NORMAL	EQU	0
DM_OFFLINE	EQU	1
DM_MATEOFF	EQU	2

;ASCII equates
CR	EQU	0DH			;ASCII carriage return
LF	EQU	0AH			;ASCII line feed
ROM_READ EQU	01			;
CV_MAX	 EQU	10			;maximum number of volumes
RETRIES EQU	0AH			;
WAIT	EQU	00H			;

;**************************************************************************

	INCLUDE SYSTEM.EQU		; bring in system dependent values

;**************************************************************************
;
; STORAGE
;
;**************************************************************************

EVEN
ROMADD: DD	0			;address of ROM jumps
CORPTR: DD	0			;address of CORTAB
DD_OFF: DW	RHHDR			;point at fake request header
	DW	0			;
HANDLE: DW	0			;file handle
XMITDESC:DB	0,0AH			;
UTILSTR:DB	"UTILHOOK",0            ;device 'UTILHOOK'

;CORTAB stuff
BSERVER:DB	0			;boot server
XPORTER:DB	0FFH			;our transporter number
CV_SUP: DB	0			;number of supported volumes
FLOPPIES: DB	0			;number of units used
DVRTYP: DB	0			;0 = built in driver
					;1 = PCSHARE
					;2 = NETBOSS

;Request Header
RHHDR:	DB	13 DUP (0)		;
	DB	0			;
	DD	0			;
CMDOFF: DW	81H			;
CMDSEG: DW	0			;

SHADOW_TBL	DB	DT_OFFLINE		       ; drive type
		DB	DT_OFFLINE		       ; server number of mate
;						       ; .. (shadow mode only)
MAX_SRVRS	EQU	   63		; Highest possible disk server number (v6.0)
		DB	(2*MAX_SRVRS) DUP (DT_OFFLINE) ; space for the rest of
;						       ; ... the table.

READSTATUS	LABEL	NEAR		;(v6.0 nod)
	DB	53H			;Opcode = SHADOW command
	DB	05H			;Sub Op = Get SHADOW status

SHADOW_STATUS	LABEL	NEAR		;(v6.0 nod)
DRVMODE DB	0			;Drive mode flag
DRVTYPE DB	0			;Drive type flag
MATEADR DB	0			;Mate address
MATESTS DB	0			;Mate status flag

GOOFFLINE	LABEL	NEAR		;(v6.0 nod)
	DB	53H			;Opcode = SHADOW command
	DB	04H			;Sub Op = Set drive offline

;Corvus tables
BPBTBL: DB	82H DUP (0)		;
MNTTBL: DB	0AH DUP (0)		;
CORMAP: DB	32H DUP (0)		;
USER:	DB	10 DUP	(0)		;

;**************************************************************************
;
; LITERALS
;
;**************************************************************************

ERRHDR: DB	CR,LF,BELL,"LOGON ["
	DB	VER+30H,".",REV+30H,SUBREV+30H,"] - ","$"
WRCORMG:DB	"CORDRV version [5.6] or above needed.",CR,LF,"$"
NOCORMG:DB	"Cannot find CORTAb.",CR,LF,"$"
EXITMSG:DB	"Exiting ...",CR,LF,"$"

;**************************************************************************

VIDEO:	DD	0			;offset & segment of VIDEO stuff
ROMJMPS LABEL	NEAR			;
CRVIO	LABEL	NEAR			;call to I/O routines in driver
	JMP	CS:DWORD PTR [ROMADD]	;

PAGE
;**************************************************************************
;
; FILE ROUTINES
;
;**************************************************************************

OPENUTL PROC	NEAR
	MOV	DX,OFFSET UTILSTR	;open 'UTILHOOK' character device
	MOV	AH,3DH			;
	MOV	AL,2			;
	INT	21H			;
	MOV	WORD PTR HANDLE,AX	;save file handle
	RET				;carry set means error
OPENUTL ENDP

;**************************************************************************

CLSFIL	PROC	NEAR
	MOV	AH,3EH			;close
	INT	21H			;
	RET				;carry set means error
CLSFIL	ENDP

;**************************************************************************

FNDCOR	PROC	NEAR
	MOV	BX,WORD PTR HANDLE	;get handle
	MOV	AH,40H			;write 2 characters to 'UTILHOOK'
	MOV	CX,2			;.this will reset pointer to
	MOV	DX,OFFSET UTILSTR	;.CORTAb, get characters from name
	INT	21H			;
	MOV	AH,3FH			;now read 4 bytes from 'UTILHOOK'
	MOV	CX,4			;.the segment & offset of CORTAb
	MOV	DX,OFFSET CORPTR	;
	INT	21H			;
	RET				;carry set means error
FNDCOR	ENDP


;**************************************************************************

SETUP	PROC	NEAR
	CALL	OPENUTL 		;open 'UTILHOOK'
	JC	SHORT %%ERROR		;
	CALL	FNDCOR			;get address of CORTAb
	JC	SHORT %%ERROR		;
	CALL	CLSFIL			;
	JC	SHORT %%ERROR		;
	PUSH	DS			;
	LDS	SI,DWORD PTR CORPTR	;get pointer to CORTAb

	MOV	AL,BYTE PTR [SI+6]	;check CORDRV version, if equal then
	CMP	AL,CORVER		;.check revision; if version is not
	JNE	SHORT SETUP0		;.equal then check if version is
	MOV	AL,BYTE PTR [SI+7]	;.greater
	CMP	AL,CORREV		;
	JGE	SHORT SETUP1		;

WRGCOR: MOV	DX,OFFSET WRCORMG	;wrong CORDRV version message
	POP	DS			;
	STC				;
	RET				;

%%ERROR:MOV	DX,OFFSET NOCORMG	;cannot find CORTAb message
	RET				;

SETUP0: CMP	AL,CORVER		;if version is less than give error
	JL	SHORT WRGCOR		;

SETUP1: MOV	BX,WORD PTR [SI+17H]	;save ROM I/O call jump address
	ADD	BX,0AH			;(points at I/O jump)
	MOV	CS:WORD PTR ROMADD,BX	;
	MOV	CS:WORD PTR ROMADD+2,DS ;the VIDEO routine jump is a FAR
	SUB	BX,0EH			;.jump right before ROM jumps in
	MOV	AX,WORD PTR [BX]	;.CORDRV
	MOV	CS:WORD PTR VIDEO,AX	;
	MOV	AX,WORD PTR [BX+2]	;
	MOV	CS:WORD PTR VIDEO+2,AX	;
	MOV	AL,BYTE PTR [SI+15H]	;save number of units already used
	MOV	CS:BYTE PTR FLOPPIES,AL ;
	MOV	AL,BYTE PTR [SI+1BH]	;save transporter number
	MOV	CS:BYTE PTR XPORTER,AL	;
	MOV	AL,BYTE PTR [SI+23H]	;save boot server
	MOV	CS:BYTE PTR BSERVER,AL	;
	CLC				;show no error
	POP	DS			;
	RET				;
SETUP	ENDP

PAGE
;**************************************************************************
;
; LOGON -
;
;**************************************************************************

HELLOC2 LABEL	NEAR

	INCLUDE LOGON.INC

PAGE
;**************************************************************************
;
; MAIN -
;
;**************************************************************************

MAIN	PROC	NEAR
	MOV	AX,CS			;
	MOV	DS,AX			;
	MOV	ES,AX			;

	CALL	SETUP			;find video jump and rom entry points
	JC	SHORT %ERROR		;

	MOV	AX,CS			;setup to command line parsing
	MOV	WORD PTR DD_OFF+2,AX	;
	MOV	WORD PTR CMDSEG,AX	;

	CALL	HELLOC2 		;get user name, mount volumes

	JMP	EXIT1			;

%ERROR: CALL	HOME			;
	PUSH	DX			;save error message
	MOV	DX,OFFSET ERRHDR	;print error header
	CALL	PRNTSTR 		;
	POP	DX			;restore error message and print
	CALL	PRNTSTR 		;exit

EXIT:	CALL	HOME			;
	MOV	DX,OFFSET EXITMSG	;
	CALL	PRNTSTR 		;
EXIT1:	MOV	AH,4CH			;exit system call
	XOR	AL,AL			;show no error
	INT	21H			;bye

MAIN	ENDP

;**************************************************************************

CODE	ENDS
	END	START




