/*
 *FILE: armintc.h
 *
 *DESCRIPTION:
 * A C language header file that defines the interface to the ram resident 
 * part of the Springborad interface software.
 */



/*
 * Software interupt number used to communicate with the ram resident part of the
 * ARM PC interface software.
 */
# define ARMINT		0x64



/*
 * Signature that the the ram resident section is loaded.
 */
/* Spare interupt vector used for signature */
# define ARMSINT	0x65
/* The signatures placed in the vector.  (ARMSIG2 is MSW) */
# define ARMSIG1	1234
# define ARMSIG2	2345




/*
 * Function codes,  value passed in ax register,  in an ARMINT call to the
 * ram resident software.  Determines what action the ram resident software
 * will take.
 */

# define ARMINIT	0		/* INITialise program */
# define ARMCON		1		/* CONect PC's keyboard and screen to the ARM.
							 * exit on <ctrl esc> pressed or command 'exit' */
# define ARMCONC	2		/* CONect inserting Command string into keyboard
							 * buffer.  Exit as ARMCON. */ 
# define ARMRESET	3		/* Silently RESET arm */
# define ARMCCE		4		/* Connect pass Command and exit when keyboard
							 * buffer has been read. */
# define ARMBKR		5		/* Block transfer read.  (PC to ARM).  Wait for
							 * ARM if necessary. */
# define ARMBKW		6		/* Block transfer write.  (ARM to PC).  Wait for
							 * ARM if necessary. */
# define ARMCCAE	7		/* Connect inserting string into keyboard buffer,
							 * return to DOS when ARM application finishes. */
# define ARMSERV	8		/* Service one tube register 2 command.  (all 
							 * OS calls except WRCH). */
# define ARMPOLL	9		/* Check if the ARM is waiting to perform i/o. */
# define ARMEXEC	10		/* Reset ARM,  load and execute (*run) a file in
							 * the ARM.  (Produces no screen output). */						 
# define ARMRDCH	11		/* Put a character into the ARM's keyboard buffer
			                 */
# define ARMWRCH	12		/* Read a character from the ARM's output stream
			                 * ie Tube register 1
			                 */
# define ARMBKGET	13		/* Transfer a block of memory from ARM to PC in
							 * the background of the ARM.
							 */
# define ARMBKPUT	14		/* Transfer a block of memory from PC to ARM in
							 * the background of the ARM.
							 */
# define ARMREENT	15		/* Check to see if some one else is already
							 * running the code.  Returns OTHERINC if some
							 * one is and FNOK if ok to make ARMINT calls.
							 * This call is reentrant unlike all others.
							 */
# define ARMEVENT	16		/* Generate an event on the ARM card
							 */
# define ARMERROR	17		/* Generate an error on the ARM card
							 */
# define ARMADDR	18		/* Set the base address for the ARM card
							 */




/*
 * Return values to the DOS application in ax from the ARMINT calls.
 */

/* FROM all calls.  Success,  or no action required. */
# define FNOK			0x00

/* FROM ARMREENT.  Some one else is running the code. */
# define OTHERINC		0x01

/* FROM ARMBKR, ARMBKW.
 */
/* Don't wait and tube had no command waiting.  Not an error.*/
# define BKNOCMD 		0x02
/* Error tube transfer has failed.  Fatal error,  reset arm. */
# define BKERTUBE		0x11
/* A command was received across the tube which was not an
 * OSFILE command.  Fatal error,  reset arm. */
# define BKBADCMD		0x12
/* An OSFILE was received but not with a qwerky file name.
 * Fatal error reset arm. */
# define BKBADFILE		0x13
/* Error,  tube is not idle.  A possibly recoverable error. */
# define BKERIDLE		0x14
/* Buffer in ARM to small to receive data to be sent. */
# define BKERLEN		0x15
/* Bad OSFILE operation. Ie. something other than function 0 or 255 */
# define BKBADOP		0x16
/* Buffer in PC to small to receive data from ARM */
# define BKPCLEN		0x17

/* FROM ARMINIT. */
/* Hardware fault.  Failed to detect card at given address. */
# define INITEALL		0x21
/* Software fault.  Eg no memory,  or ram resident code corrupt. */
# define INITEF			0x22

/* FROM all unknown function codes. */
# define FUNCUNK		0x31

/* FROM ARMPOLL. */
# define TBCMNDPEND		0x42
# define TBVDUPEND		0x46

/* FROM ARMSERV */
# define TBCMNDNPEND	0x41
# define TBCMNDFAIL		0x43
# define TBCMNDRDCHS	0x44
# define TBCMNDSERV		0x45

/* FROM ARMEXEC. */
/* File not found. */
# define EXECNOFILE		0x51
/* Failed for some other reason. */
# define EXECFAIL		0x52

/* FROM ARMWRCH,  ARMRDCH */
# define STDINFULL		0x61
# define STDOUTEMPTY	0x62

/* FROM ARM Connect functions. */
# define CONFAIL		0x70
# define CONCFAIL		0x71
# define CCEFAIL		0x72
# define CCAEFAIL		0x73

/* FROM ARMBKGET, ARMBKPUT. */
# define BKGETFAIL		0x80
# define BKPUTFAIL		0x81

/* FROM ARMEVENT */
# define EVENTFAIL		0x91

/* FROM ARMERROR */
# define ERRORFAIL		0x92

/* FROM ARMADDR */
# define ADDRFAIL		0x93





/* FROM OSFILE.
 * Values returned to the ARM in R0 when participating in a synchronous block
 * transfer.
 */
/* Successfull block transfer. */
# define BLKARMOK		1
/* Failed due to the receive buffer in the ARM being too small. */
# define BLKARMSMALL	10
/* Failed due to the receive buffer in the PC being too small. */
# define BLKARMSMALL2	11
