#!/bin/csh -f
#
#/*  @(#)cdi.csh	8.5 6/20/96  */
#
# A script to install a Xilinx CDROM without the X-based install program.
#
umask 2
setenv SYSTYPE sys5.3
set path = ( /usr/ucb /bin /usr/bin )
if ( -d /usr/bsd         ) set path = (/usr/bsd $path )
if ( -d /usr/bin/X11     ) set path = ($path /usr/bin/X11 )
if ( -d /usr/openwin/bin ) set path = ($path /usr/openwin/bin )
rehash
#
set this_file        = $0
set this_dir  = $this_file:h
set this_file = $this_file:t
if ( "${this_file}" == "${this_dir}" ) set this_dir = $cwd
set this_dir  = `(cd $this_dir ; echo $cwd)`
set prog_dir  = $this_dir
#
set version = "5.2.1"
#
echo "          Xilinx CDROM Software Installation Startup Script $version "
echo ""
#
cat << END_OF_COPYRIGHT
===============================================================================
 
                        Copyright 1996 by Xilinx
                          All Rights Reserved.
 
===============================================================================
END_OF_COPYRIGHT
#
#
# Determine the cpu type
#
set cpu_type = "Unknown"
if ( -d /usr/apollo  ) set cpu_type = apollo
if ( -e /bin/mach    ) set cpu_type = `/bin/mach`
if ( -e /bin/machine ) set cpu_type = `/bin/machine`
if ( -e "/bin/uname" ) then
   if ( "`/bin/uname -m`" == "alpha"  ) set cpu_type = "alpha"
   if ( "`/bin/uname -m`" =~  9000/*  ) set cpu_type = "hppa"
   if ( "`/bin/uname`"    == "AIX"    ) set cpu_type = "rs6000"
   if ( "`/bin/uname`"    == "IRIX"   ) set cpu_type = "sgi4d"
   if ( "`/bin/uname`"    == "SunOS"  ) set cpu_type = "sparc"
endif
#
unalias cd
unalias chmod
unalias df
unalias mkdir
unalias rm
#
if ( $cpu_type == "hppa" ) then
   alias df bdf
endif
if ( `uname` == "SunOS" && `uname -r` =~ 5* ) then
   alias df df -k
endif
set p_opt=-p
#
set dlr = '$'
#
set CDROM_dir = /cdrom
#
set cpu_list  = (alpha apollo dos hppa mc68020 mips rs6000 sgi4d sparc)
#
set type_list_C = (DA1  AP1   PC1  HP7  SN1    DS1  RS1   SG1  SN2  )
set type_list   = (da1  ap1   pc1  hp7  sn1    ds1  rs1   sg1  sn2  )
 
unset user_plat
unset for_plat
set   yappy = 0
#
set bad_opts = ()
#
set i = 0
while ( $i < $#argv )
   @ i ++
   switch(${argv[$i]})
    case "-CD":
    case "-cd":
    case "-C":
    case "-c":
        @ i ++
        set CDROM_dir = $argv[$i]
        echo " -CD: CDROM assumed to be mounted as $CDROM_dir "
	if ( ! -d $CDROM_dir ) then
	   echo ""
	   echo "Warning: $CDROM_dir is not a directory."
	   echo ""
	endif
        breaksw
    case "-FOR":
    case "-for":
    case "-F":
    case "-f":
        @ i ++
        set for_plat = $argv[$i]
        echo " Installation of $for_plat products requested. "
        if ( " $type_list "   =~ *\ $for_plat\ * ) breaksw
        if ( " $type_list_C " =~ *\ $for_plat\ * ) breaksw
        if ( " $cpu_list "    =~ *\ $for_plat\ * ) breaksw
           echo ""
           echo "Error: (145) -for must specify one of:"
           echo ""
           echo "       $type_list "
           echo "     ( $type_list_C on some machines ) "
           echo ""
           echo " or    $cpu_list "
           echo ""
           @ bad_opts ++
        breaksw
    case "-XACT_ROOT":
    case "-xact_root":
    case "-X":
    case "-x":
        @ i ++
        if ( ! -e $argv[$i] ) then
           echo ""
           echo "Warning (167): '${argv[$i]}' does not exist, will be created."
           echo ""
        endif
        set xact_root = "$argv[$i]"
        breaksw
    case "-YAPPY":
    case "-yappy":
    case "-Y":
    case "-y":
        @ yappy ++
        breaksw
#
    default:
        set bad_opts = ($bad_opts $argv[$i])
        echo "Unrecognized option: '$argv[$i]' "
   endsw
end
#
if ( $#bad_opts > 0 ) exit 1
#
if ( ! $?xact_root ) then
   set xact_root = "$cwd"
   if ( "${xact_root}" !~ */xact ) set xact_root = $cwd/xact
endif
#
xact_check:
echo ""
echo "Installing files to $xact_root"
if ( ! -e $xact_root ) then
   echo ""
   echo " ( It does not exist, and will be created. )"
endif
echo ""
echo "   Enter 'Q' or 'q' to quit; "
echo "   or specify a new XACT directory;"
echo "   or just hit Return or Enter to continue."
echo -n " Response : "
set ans = $<
set ans = `echo $ans |sed -e 's/ *$//'`
if ( "${ans}" =~ [Qq] ) then
   echo ""
   echo " Quitting..."
   echo ""
   exit
endif
if ( "${ans}" != "" ) then
   set xact_root = $ans
   goto xact_check
endif
echo ""
#
if ( ! -d $xact_root ) mkdir $xact_root
if ( ! -d $xact_root ) then
   echo "ERROR: Could not create directory $xact_root "
   goto xact_check
endif
#
#
#----------------------------------------------------------------------
#
while ( "${cpu_type}" == "Unknown" )
   echo ""
   echo "Warning (223): cannot determine the type of this machine. "
   echo ""
   echo " Please enter a cpu type from the following list, or 'Q' to quit. "
   echo ""
   echo " $cpu_list "
   echo ""
   echo -n " Selection : "
   set ans = $<
   set ans = `echo $ans |sed -e 's/ *$//'`
   if ( $#ans > 1 ) then
      echo "Please enter only a single platform."
      continue
   endif
   if ( "${ans}" =~ [Qq] ) then
        echo ""
        echo " Quitting..."
        echo ""
        exit
   endif
   foreach type ($cpu_list)
        if ( "${ans}" == "${type}" ) then
           set cpu_type = "${type}"
           break
        endif
   end
   if ( "${cpu_type}" == "Unknown" ) echo " Sorry: $ans wasn't recognized."
end
#
set plat_opt = pc1
set i = 0
foreach w ($cpu_list)
   @ i ++
   if ( "${cpu_type}" == "${w}" ) then
      set plat_opt = "$type_list[$i]"
      break
   endif
end
#
echo " This machine was determined to be of cpu type '${cpu_type}'."
echo " The corresponding product type is : -${plat_opt}. "
 
if ( ! $?for_plat) then
  set for_plat = $plat_opt
endif
#
if ( $?user_plat ) then
   unset user_plat_opt
   set i = 0
   foreach w ($cpu_list)
      @ i ++
      if ( "${user_plat}" == "${w}" ) then
         set user_plat_opt = "$type_list[$i]"
         break
      endif
   end
   if ( ! $?user_plat_opt ) then
      set i = 0
      foreach w ($type_list)
         if ( "${user_plat}" == "${w}" ) then
            set user_plat_opt = "${w}"
            break
         endif
      end
   endif
   if ( ! $?user_plat_opt ) then
        echo ""
        echo " Sorry: '$user_plat' is not a supported platform type."
        echo ""
        echo "   You may only use names from the following lists:"
        echo ""
        echo "   ${cpu_list} "
        echo "   ${type_list} "
        echo ""
        exit 1
   endif
endif
if ( $?user_plat_opt ) then
   set plat_opt = $user_plat_opt
   echo ""
   echo " You have asserted that this is the ${plat_opt} platform. "
   echo ""
endif
#
set plat_opt_lc = `echo $plat_opt | sed -e 'y/ABCEDFGHIJKLMNOPQRSTUVWXYZ/abcedfghijklmnopqrstuvwxyz/'`
#
set i = 0
foreach w ($cpu_list)
   @ i ++
   if ( $plat_opt == "$type_list[$i]" ) then
      set cpu_opt  = "${w}"
      break
   endif
end
#
#
#
if ( $?for_plat ) then
   unset for_plat_opt
   set i = 0
   foreach w ($cpu_list)
      @ i ++
      if ( "${for_plat}" == "${w}" ) then
         set for_plat_opt = "$type_list[$i]"
         break
      endif
   end
   if ( ! $?for_plat_opt ) then
      set i = 0
      foreach w ($type_list)
         if ( "${for_plat}" == "${w}" ) then
            set for_plat_opt = "${w}"
            break
         endif
      end
   endif
   if ( ! $?for_plat_opt ) then
        echo ""
        echo " Sorry: '$for_plat' is not a supported platform type."
        echo ""
        echo "   You may only use names from the following lists:"
        echo ""
        echo "   ${cpu_list} "
        echo "   ${type_list} "
        echo ""
        exit 1
   endif
endif
if ( $?for_plat_opt ) then
   set for_plat = $for_plat_opt
   echo ""
   echo " You have chosen to install the -${for_plat} products. "
   echo ""
endif
#
#
set for_plat_lc = `echo $for_plat | sed -e 'y/ABCEDFGHIJKLMNOPQRSTUVWXYZ/abcedfghijklmnopqrstuvwxyz/'`
set for_plat_uc = `echo $for_plat | sed -e 'y/abcedfghijklmnopqrstuvwxyz/ABCEDFGHIJKLMNOPQRSTUVWXYZ/'`
#
#
#----------------------------------------------------------------------
#
# Is this a normal mount or a Sun hsfs mount?
#
unset lower_case
unset upper_case
#
if ( "${this_file}" == "cdi.csh" || "${this_file}" == "cdi" || "${this_file}" == "cdi." ) then
   set lower_case
   set cd_for_opt  = ($for_plat_lc)
   set cd_plat_opt = ($plat_opt_lc)
   set check_dirs  = ($for_plat_lc)
   set check_files = (xilinx.cd)
   set program = "xinstall"
   if ( "${this_file}" == "cdi." ) set program = "xinstall."
else if ( "${this_file}" == "CDI.CSH;1" || "${this_file}" == "CDI.;1" ) then
   set upper_case
   set cd_for_opt  = ($for_plat)
   set cd_plat_opt = ($plat_opt)
   set check_dirs  = ($for_plat)
   set check_files = (XILINX.CD\;1)
   set program = "xinstall"
else if ("${this_file}" == "CDI.CSH" || "${this_file}" == "CDI") then
   set upper_case
   set cd_for_opt  = ($for_plat)
   set cd_plat_opt = ($plat_opt)
   set check_dirs  = ($for_plat)
   set check_files = (XILINX.CD)
   set program = "xinstall"
else
   echo ""
   echo "Sorry: this script cannot determine the location of"
   echo "       the Xilinx CDROM Installation software. "
   echo "       Please consult your installation guide. "
  echo ""
   exit 1
endif
#
#
# Where is the CDROM mounted?
#
#
set changed = "no"
set okay    = "YES"
foreach d ($check_dirs)
   if ( ! -d $CDROM_dir/$d ) then
     set upd = `echo $d | sed -e 'y/abcedfghijklmnopqrstuvwxyz/ABCEDFGHIJKLMNOPQRSTUVWXYZ/'`
     if ( -d $CDROM_dir/$upd ) then
	set changed = "yes"
     else
	set okay = "NO"
     endif
   endif
end
if ( "${changed}" != "no" ) then
  set check_files = (`echo $check_files |sed -e 'y/abcedfghijklmnopqrstuvwxyz/ABCEDFGHIJKLMNOPQRSTUVWXYZ/'`)
  set check_dirs  = (`echo $check_dirs  |sed -e 'y/abcedfghijklmnopqrstuvwxyz/ABCEDFGHIJKLMNOPQRSTUVWXYZ/'`)
   set   upper_case
   unset lower_case
endif
foreach f ($check_files)
   if ( ! -f $CDROM_dir/$f && ! -f $CDROM_dir/$f.\;1 ) set okay = "NO"
end
if ( "${okay}" == "YES" ) goto cdrom_found
#
cdrom_check:
# Try to guess where the CDROM is mounted:
set fs_type    = ""
if ( "${cpu_type}" == "sparc" || "${cpu_type}" == "mc68020" ) then
   set fs_type = "hsfs"
else if ( "${cpu_type}" == "apollo" || "${cpu_type}" == "hppa" ) then
   set fs_type    = "cdfs"
else if ( "${cpu_type}" == "alpha" ) then
   set fs_type = 'ufs *(ro)'
else if ( "${cpu_type}" == "mips" ) then
   set fs_type = "cdfs"
else if ( "${cpu_type}" == "rs6000" ) then
   set fs_type = "cdrfs"
else if ( "${cpu_type}" == "sgi4d" ) then
   set fs_type = "iso9660"
endif
#
set mount_opts = ""
if ( "${cpu_type}" == "hppa" ) set mount_opts = "-p"
#
# On some systems mount reports "/dev/blah on /mountdir", but
#
# on others it's "/mountdir on /dev/blah" or "/dev/blah /mountdir" ...
set mount_place = 3
if ( "${cpu_type}" == "hppa"   ) set mount_place = 2
if ( "${cpu_type}" == "rs6000" ) set mount_place = 2
#
set dollar = '$'
set mlist = `/etc/mount $mount_opts | grep "${fs_type}" | awk "{print $dollar$mount_place}"`
#
if ( $#mlist > 0 ) then
   echo ""
   echo " Looking at the mounted file systems, likely CDROM mount points are:"
   echo ""
   foreach mp ($mlist)
      echo "     $mp "
   end
endif
#
set i = 0
while ( "${okay}" != "YES" )
   set default_mp = "$CDROM_dir"
   if ( $#mlist == 1 ) then
        set default_mp = "$mlist[1]"
   endif
   echo ""
   echo -n "Where is the CDROM mounted ? (Q to quit) ( $default_mp ) : "
   set CDROM_dir = $<
   set CDROM_dir = `echo $CDROM_dir |sed -e 's/ *$//'`
   if ( "${CDROM_dir}" == "Q" || "${CDROM_dir}" == "q" ) then
        echo ""
        echo " Quitting..."
        echo ""
        exit
   endif
   if ( $#CDROM_dir > 1 ) then
      echo "Please enter only a single path."
      set CDROM_dir = "$default_mp"
      continue
   endif
   if ( "${CDROM_dir}" == "" ) set CDROM_dir = "$default_mp"
   if ( "${CDROM_dir}" == "" ) set CDROM_dir = "$cwd"
   set okay = "YES"
   foreach d ($check_dirs)
        if ( ! -d $CDROM_dir/$d ) set okay = "NO"
   end
   set new_cfiles = ()
   foreach f ($check_files)
        if ( -f $CDROM_dir/$f ) continue
        if ( -f $CDROM_dir/$f\;1 ) then
          set new_cfiles = ($new_cfiles $f\;1)
        else if ( -f $CDROM_dir/$f.\;1 ) then
          set new_cfiles = ($new_cfiles $f.\;1)
	else
	   set okay = "NO"
	endif
   end
   if ( $#new_cfiles > 0 ) set check_files = ($new_cfiles)
   @ i++
   if ( "${okay}" != "YES" ) then
     echo " Looking in $CDROM_dir, "
     echo " the install directories or files were not found. "
     if ( $i >= 3 ) then
        echo " Do you want to Guess again, Quit, "
        echo " or Proceed with the current mount name ?"
        echo ""
        echo " (If you proceed, the install will almost certainly FAIL;"
        echo "  do NOT select P unless you have some special reason to"
        echo "  think the install can succeed.)"
        echo ""
        echo -n "Please enter  G, Q, or P : [G] "
        set ans = $<
        set ans = `echo $ans |sed -e 's/ *$//'`
        set ans = $ans[1]
        if ( "${ans}" == "Q" || "${ans}" == "q" ) then
            echo ""
            echo " Quitting..."
            echo ""
            exit
        else if ( "${ans}" == "P" || "${ans}" == "p" ) then
            echo "Okay... proceeding with ${CDROM_dir}."
            goto cdrom_found
        else
            set i = 0
            echo "Okay... Three more guesses."
        endif
     endif
   endif
end
#
cdrom_found:
echo ""
echo "----------------------------------------------------------------"
echo " ( found ${CDROM_dir}/$check_files[1] ) "
echo " The CDROM is assumed to be mounted on  : $CDROM_dir "
echo "   Enter 'Q' or 'q' to quit; or "
echo "   enter any other character to respecify the CDROM mount directory,"
echo "   or just hit Return or Enter to continue, "
echo -n " Response : "
set ans = $<
set ans = `echo $ans |sed -e 's/ *$//'`
if ( "${ans}" =~ [Qq] ) then
   echo ""
   echo " Quitting..."
   echo ""
   exit
endif
if ( "${ans}" != "" ) goto cdrom_check
echo ""
#
#----------------------------------------------------------------------
#
set cddata = "$for_plat_uc/INSTALL"
if ( $?lower_case  ) set cddata = `echo $cddata |sed -e 'y/ABCEDFGHIJKLMNOPQRSTUVWXYZ/abcedfghijklmnopqrstuvwxyz/'`
if ( $?upper_case  ) set cddata = `echo $cddata | sed -e 'y/abcedfghijklmnopqrstuvwxyz/ABCEDFGHIJKLMNOPQRSTUVWXYZ/'`
set cddata = "$CDROM_dir/$cddata"
if ( ! -d $cddata ) then
   echo ""
   echo "Error: (543) can't find CDROM $cddata directory. "
   echo ""
   echo -n "   Enter 'Q' or 'q' to quit, anything else to retry : "
   set ans = $<
   set ans = `echo $ans |sed -e 's/ *$//'`
   if ( "${ans}" !~ [Qq] ) goto cdrom_check
   exit 1
endif
#
set this_plat = $cpu_type
unset this_type
set i = 0
while ( $i < $#cpu_list )
  @ i ++
  if ( "${this_plat}" == "${cpu_list[$i]}" ) then
     if ( $?lower_case ) then
	set this_type = "${type_list[$i]}"
        if ( -d "$CDROM_dir/$this_type/install" ) set path = ($path "$CDROM_dir/$this_type/install")
     endif
     if ( $?upper_case ) then
	set this_type = "${type_list_C[$i]}"
        if ( -d "$CDROM_dir/$this_type/INSTALL" ) set path = ($path "$CDROM_dir/$this_type/INSTALL")
     endif
  endif
end
if ( ! $?this_type ) set this_type = $this_plat
#
if ( $?lower_case  ) set this_plat = `echo $this_plat |sed -e 'y/ABCEDFGHIJKLMNOPQRSTUVWXYZ/abcedfghijklmnopqrstuvwxyz/'`
if ( $?upper_case  ) set this_plat = `echo $this_plat | sed -e 'y/abcedfghijklmnopqrstuvwxyz/ABCEDFGHIJKLMNOPQRSTUVWXYZ/'`
#
set idatfile = "$cddata/install.dat"
if ( -e $cddata/INSTALL.DAT    ) set idatfile = "$cddata/INSTALL.DAT"
if ( -e $cddata/INSTALL.DAT\;1 ) set idatfile = "$cddata/INSTALL.DAT;1"
#
set copyright = "$cddata/cr.txt"
if ( -e $cddata/CR.TXT    ) set copyright = "$cddata/CR.TXT"
if ( -e $cddata/CR.TXT\;1 ) set copyright = "$cddata/CR.TXT;1"
#
#
review:
#
if ( -e $copyright ) goto file_license
#
cat << END_OF_LEGEND
                        RESTRICTED RIGHTS LEGEND
 
If this product is acquired under the terms of a:
 
 DoD contract:
     Use, duplication, or disclosure by the Government is subject to
     restrictions as set forth in subparagraph (c)(1)(ii) of the
     Rights in Technical Data and Computer Software clause at
     DFARS 252.227-7013
 Civilian agency contract:
     Use, reproduction or disclosure subject to 52.227-19 (a) through (d)
     and restrictions set forth in the accompanying end user agreement.
     Unpublished-rights reserved under the copyright laws of the United States.
     Xilinx, Inc., 2100 Logic Drive, San Jose, California  95124-3450
 
END_OF_LEGEND
#
goto lic_agree
#
#------------------------------------------------------------------------
#
file_license:
#
more $copyright
#
echo " A copy of the license agreement is in: "
echo "   $copyright"
#
echo "------------------------------------------------------------------------"
#
#
#------------------------------------------------------------------------
#
lic_agree:
#
cat << END_OF_TANDC
 
 By installing this Software, you are warranting that you have read and
 understood the terms and conditions of the Xilinx Software License Agreement
 and agree to be bound by these terms and conditions.  A hard copy of the
 agreement was also enclosed with the Software.
 
 If you do not agree to the terms and conditions of this license, promptly
 return the unused Software to the place where you obtained it and your
 money will be refunded.
 
END_OF_TANDC
#
#
echo    "Enter 'A' or 'a' to Accept  the terms and conditions;"
echo    "      'Q' or 'q' to Decline the terms and quit; "
echo -n "  or any other character to review the terms and conditions : "
set ans = $<
set ans = `echo $ans |sed -e 's/ *$//'`
echo ""
if ( "${ans}" == "Q" || "${ans}" == "q" ) exit 1
if ( "${ans}" != "A" && "${ans}" != "a" ) goto review
#
#========================================================================
#
echo ""
#
#
unset use_semicolon
if ( "${idatfile}" =~ *\;* ) set use_semicolon
#
if ( -x "$CDROM_dir/$this_type/install/unzip" ) set unzip = "$CDROM_dir/$this_type/install/unzip"
if ( -x "$CDROM_dir/$this_type/install/unzip." ) set unzip = "$CDROM_dir/$this_type/install/unzip."
if ( -x "$CDROM_dir/$this_type/INSTALL/UNZIP" ) set unzip = "$CDROM_dir/$this_type/INSTALL/UNZIP"
if ( -x "$CDROM_dir/$this_type/INSTALL/UNZIP.;1" ) set unzip = "$CDROM_dir/$this_type/INSTALL/UNZIP.;1"
if ( $?UNZIP ) then
  if ( -x $UNZIP ) then
     set unzip = $UNZIP
     echo "WARNING: using UNZIP = '$UNZIP'."
  else
     echo "WARNING: UNZIP = '$UNZIP' is not executable.  Ignored."
  endif
endif
if ( ! $?unzip ) then
   set unzip = unzip
   foreach d ($path)
     if ( -x $d/unzip ) then
	set unzip = $d/unzip
	break
     endif
   end
endif
#
if ( "${unzip}" == "unzip" ) then
   echo "WARNING: Couldn't find unzip on the CD or in your path."
   echo "       Please either change your path, or define UNZIP"
   echo "       by: setenv UNZIP <path to unzip>, so that "
   echo "       unzip can be run by the command '${dlr}UNZIP'"
   echo ""
   set list = `find ${CDROM_dir}/*/* -name '*.zip' -print -o -prune`
   if ( $#list == 0 ) then
      echo "       This CDROM seems NOT to have .zip files; continuing..."
      echo ""
   else
      echo "       This CDROM seems to have .zip files; quitting."
      echo ""
      exit 1
   endif
endif
#
#
grep '$product,' ${idatfile} \
  | awk 'BEGIN {FS=","} {printf("%s\n%s\n%s\n", $2, $3, $4)}' > /tmp/products.$$
#
set prods  = ()
set pvers  = ()
set pdescs = ()
#
set nlines = `wc -l /tmp/products.$$ | awk '{print $1}'`
@ nprods = $nlines / 3
@ test = $nprods * 3
if ( $test != $nlines ) then
   echo "ERROR: input problem, 3 * nprods = $test, nlines = $nlines"
endif
#
set i = 0
while ( $i < $nlines )
  @ i ++
  set prods  = ($prods  `sed -n ${i}p /tmp/products.$$`)
  @ i ++
  set pvers  = ($pvers  `sed -n ${i}p /tmp/products.$$`)
  @ i ++
  set pdescs = ($pdescs `sed -n ${i}p /tmp/products.$$ |sed -e 's/ /%/g'`)
end
#
select_product:
   echo ""
   echo " Products: "
   set i = 0
   while ( $i < $nprods )
      @ i ++
      echo $i $prods[$i] $pvers[$i] \
   	| awk '{printf("%6d : %-6s %-8s ", $1, $2, $3 )}'
      echo $pdescs[$i] |sed -e 's/%/  /g'
   end
   echo    ""
   echo    " Please enter the number of the product to install "
   echo -n " or 'Q' to quit : "
   set prodnum = $<
   set prodnum = `echo $prodnum |sed -e 's/ *$//'`
   if ( "${prodnum}" =~ [qQ]* ) then
      echo " Okay: Done."
      exit 0
   endif
   #
   if ( $prodnum < 1 || $prodnum > $#prods ) then
      echo "Error: I don't understand '${prodnum}'"
      echo "       Please try again. "
      echo ""
      goto select_product
   endif
   #
   set product = $prods[$prodnum]
#
set alias_file = ${product}.da 
if ( $?lower_case  ) set alias_file = `echo $alias_file |sed -e 'y/ABCEDFGHIJKLMNOPQRSTUVWXYZ/abcedfghijklmnopqrstuvwxyz/'`
if ( $?upper_case  ) set alias_file = `echo $alias_file | sed -e 'y/abcedfghijklmnopqrstuvwxyz/ABCEDFGHIJKLMNOPQRSTUVWXYZ/'`
set alias_file = ${cddata}/${alias_file}
if ( -e ${alias_file}\;1 ) then
   set alias_file = ${alias_file}\;1
endif
#
set src_dir = `head -1 ${alias_file} | awk '{print $3}'`
if ( $?lower_case  ) set src_dir = `echo $src_dir |sed -e 'y/ABCEDFGHIJKLMNOPQRSTUVWXYZ/abcedfghijklmnopqrstuvwxyz/'`
if ( $?upper_case  ) set src_dir = `echo $src_dir | sed -e 'y/abcedfghijklmnopqrstuvwxyz/ABCEDFGHIJKLMNOPQRSTUVWXYZ/'`
#
set CDXACT = $CDROM_dir/$src_dir
if ( ! -d $CDXACT ) then
   set cdsrcdir = `echo $src_dir |sed -e 's/\(........\).*/\1/'`
   set CDXACT = $CDROM_dir/$cdsrcdir
endif
#
#
sed -e "1,/${dlr}product, ${product},/d"		\
    -e /${dlr}end_product/,${dlr}d "${idatfile}"	\
   | grep "${dlr}install_option,"			\
   | awk 'BEGIN {FS=","} {printf("%s\n%s\n%s\n%s\n", $2,$3,$4,$6)}' > /tmp/options.$$
#
sed -e 1,/^${product},c/d "${idatfile}" | sed -e /^}/,${dlr}d \
	| grep '.zip' > /tmp/ziplist.$$
#
#
set opts   = ()
set overs  = ()
set odescs = ()
set oreqs  = ()
set osels  = ()
set osizes = ()
#
set nlines = `wc -l /tmp/options.$$ | awk '{print $1}'`
@ nopts = $nlines / 4
@ test = $nopts * 4
if ( $test != $nlines ) then
   echo "ERROR: input problem, 4 * nopts = $test, nlines = $nlines"
endif
#
set j = 0
set i = 0
while ( $i < $nlines )
  @ j ++
  @ i ++
  set opts   = ($opts  `sed -n ${i}p /tmp/options.$$`)
  @ i ++
  set overs  = ($overs  `sed -n ${i}p /tmp/options.$$`)
  @ i ++
  set odescs = ($odescs `sed -n ${i}p /tmp/options.$$ |sed -e 's/ /%/g'`)
  @ i ++
  set oreqs  = ($oreqs `sed -n ${i}p /tmp/options.$$ |sed -e 's/ /%/g'`)
  #
  if ( "${oreqs[$j]}" == "Required" ) then
     set osels  = ($osels  "R")
  else
     set osels  = ($osels  "u")
  endif
end
#
#
set nlines = `wc -l /tmp/ziplist.$$ | awk '{print $1}'`
#
set i = 0
set j = 0
while ( $i < $nlines )
  @ i ++
  set line = (`sed -n ${i}p /tmp/ziplist.$$ | sed -e 's/\[//' -e 's/\]//'`)
  if ( $#line == 7 ) then
     @ j = ${line[1]} - 1	# Index for option 1 is 2; for option 2 is 3...
     set osizes = ($osizes $line[4])
  else
     @ osizes[$j] = $osizes[$j] + $line[2]
  endif
end
#
set i = 0
while ( $i < $j )
  @ i ++
  @ osizes[$i] = $osizes[$i] / 1000
end
#
set optnums = ()
#
set OM = /tmp/options_menu.$$
#
select_options:
   #
   set selected_size = 0
   /bin/rm -f  $OM
   echo ""								>! $OM
   echo " Options for $product : "					>> $OM
   echo ""								>> $OM
   echo "   (R) = Required, (S) = Selected, (u) = Unselected "		>> $OM
   echo ""								>> $OM
   set i = 0
   while ( $i < $nopts )
      @ i ++
#     echo $i $osels[$i] $opts[$i] $overs[$i] $oreqs[$i] $osizes[$i] \
#       | awk '{printf("%4d : (%s) : %-8s %-6s (%-8s) : ", $1,$2,$3,$4,$5,$6 )}' \
#									>> $OM
#
      echo $i $osels[$i] $opts[$i] $overs[$i] $osizes[$i] \
       | awk '{printf("%4d : (%s) : %-8s %-6s : %5d Kbytes: ", $1,$2,$3,$4,$5,$6)}' \
									>> $OM
      echo $odescs[$i] |sed -e 's/%/  /g'				>> $OM
      if ( "${osels[$i]}" == "R" || "${osels[$i]}" == "S" ) then
        @ selected_size = $selected_size + $osizes[$i]
      endif
   end
   more $OM
   echo    ""
   echo    "  $selected_size Kbytes selected"
   echo    ""
   echo    " Please enter the number(s) of the option(s) to install"
   echo    "   (you may enter several, and will be asked for more),"
   echo    " or enter 'Q' to quit, "
   echo    " or enter 'I' to end selections and Install now, "
   echo    " or enter 'P' to select a different product, "
   echo    " or enter 'R' to reset options and reselect, "
   echo -n " or enter 'A' to install all options : "
   set optsel = $<
   set optsel = `echo $optsel |sed -e 's/ *$//'`
   if ( "${optsel}" == "" ) then
      goto select_options
   endif
   if ( "${optsel}" =~ [qQ]* ) then
      echo " Okay: Done."
      exit 0
   endif
   #
   if ( "${optsel}" =~ [iI]* ) then
      goto install_now
   endif
   if ( "${optsel}" =~ [pP]* ) then
      goto select_product
   endif
   if ( "${optsel}" =~ [rR]* ) then
      set optnums = ()
      set osels   = ()
      set i = 0
      while ( $i < $#opts )
	@ i ++
        if ( "${odescs[$i]}" == "Required" ) then
           set osels  = ($osels  "R")
        else
           set osels  = ($osels  "u")
        endif
      end
      goto select_options
   endif
   if ( "${optsel}" =~ [aA]* ) then
      set optnums = ()
      set osels   = ()
      set i = 0
      while ( $i < $#opts )
	@ i ++
	set optnums = ($optnums $i)
	set osels   = ($osels   "S")
      end
      goto select_options
   endif
   set bad_opts = 0
   set sel_list = ($optsel)
   set i = 0
   while ( $i < $#sel_list )
      @ i ++
      if ( $sel_list[$i] < 1 || $sel_list[$i] > $nopts ) then
         echo "Error: I don't understand '${sel_list[$i]}'"
         echo "       Please try again. "
         echo ""
         @bad_opts ++
         continue
      endif
      if ( " ${optnums} " !~ *\ ${sel_list[$i]}\ * ) set optnums = ($optnums ${sel_list[$i]})
      set osels[${sel_list[$i]}] = "S"
   end
   if ( $bad_opts > 0 ) goto select_options
   set optnums = ($optnums $sel_list[$i])
   set i = 0
   while ( $i < $#opts )
      @ i ++
      if ( "${odescs[$i]}" == "Required" ) then
        if ( " ${optnums} " !~ *\ ${i}\ * ) set optnums = ($optnums $i)
      endif
   end
   #
   goto select_options
#
#----------------------------------------------------------------------
#
install_now:
#
if ( $#opts < 1 ) then
   echo ""
   echo " ERROR: no options selected."
   echo ""
   goto select_options
endif
#
set onames = ()
set i = 0
while ( $i < $#opts )
   @ i ++
   if ( "${osels[$i]}" == "R" || "${osels[$i]}" == "S" ) set onames = ($onames $opts[$i])
end
#
echo ""
echo " Options selected for $product : "
echo ""
set i = 1
set j = 9
while ( $j <= $#onames )
  @ i1 = $i + 1
  @ i2 = $i + 2
  @ i3 = $i + 3
  @ i4 = $i + 4
  @ i5 = $i + 5
  @ i6 = $i + 6
  @ i7 = $i + 7
  echo $onames[$i] $onames[$i2] $onames[$i3] $onames[$i4] $onames[$i5] $onames[$i6] $onames[$i7] $onames[$j] \
   | awk '{printf(" %-8s %-8s %-8s %-8s %-8s %-8s %-8s %-8s\n", $1,$2,$3,$4,$5,$6,$7,$8)}'
  @ i = $j
  @ j += 8
end
#
if ( $i <= $#onames ) then
  while ( $i <= $#onames )
    echo $onames[$i] | awk '{printf(" %-8s", $1)}'
    @ i ++
  end
  echo ""
endif
echo ""
#
#
set counts = ` grep '^ *[0-9]' /tmp/ziplist.$$ | awk '{print $2}'`
set zips  = ` grep '\.zip' /tmp/ziplist.$$ | sed -e 's/.*\[//' -e 's/.zip .*//'`
#
set todo = ()
set start = 1
set size  = 0
set i = 0
while ( $i < $#opts )
   @ i ++
   @ end = $start + $counts[$i]
   if ( "${osels[$i]}" == "R" || "${osels[$i]}" == "S" ) then
      set j = $start
      while ( $j < $end )
	set todo = ($todo $zips[$j])
	@ j ++
      end
   endif
   @ start = $end
end
#
echo " The selected options for $product require $selected_size Kbytes. "
echo ""
df $xact_root
echo ""
echo -n " Continue ? "
set ans = $<
set ans = `echo $ans |sed -e 's/ *$//'`
#
cd $xact_root
#
echo ""
echo " Installing $product into $xact_root"
echo ""
#
set dotzip = ".zip"
if ( $?upper_case  ) set dotzip = `echo $dotzip | sed -e 'y/abcedfghijklmnopqrstuvwxyz/ABCEDFGHIJKLMNOPQRSTUVWXYZ/'`
#
set i = 0
foreach zip ($todo)
  @ i ++
  # If we're using semicolons, we're also truncating to 8 chars...
  if ( $?use_semicolon ) set zip = `echo $zip | sed -e 's/\(........\).*/\1/'`
  if ( $?upper_case    ) set zip = `echo $zip | sed -e 'y/abcedfghijklmnopqrstuvwxyz/ABCEDFGHIJKLMNOPQRSTUVWXYZ/'`
  #
  if ( -e $CDXACT/$zip ) then
    set cmd = "tar xf $CDXACT/$zip"
  else if ( -e $CDXACT/${zip}.\;1 ) then
    set cmd = "tar xf $CDXACT/${zip}.;1"
  else if ( -e $CDXACT/${zip}${dotzip} ) then
    set cmd = "$unzip -qquo $CDXACT/$zip"
  else if ( -e $CDXACT/${zip}${dotzip}\;1 ) then
    set cmd = "$unzip -qquo $CDXACT/${zip}${dotzip};1"
  else
    echo "Error: can't find $CDXACT/$zip"
    continue
  endif
  if ( $yappy > 0 ) then
     echo "$cmd"
  else
     echo -n "
 ${i} of $#todo : ${zip}            "
  endif
  $cmd
end
#
echo ""
echo " Done. "
#
echo ""
echo "du -s $xact_root/*"
echo ""
du -s $xact_root/*
echo ""
#
/bin/rm -f $OM /tmp/options.$$ /tmp/products.$$ /tmp/ziplist.$$
#
