/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1990, 1991, 1992, 1993 and 1994 by      *
* Cadence Design Systems .                                                    *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

LIBRARY        : Xilinx XC4000E Library
FUNCTION       : D-LATCH WITH GLOBAL RESET (gsr)
REFERENCE      : Xilinx Simulation Guide
                 
DESIGNER       : Sanjeev Aggarwal
DATE GENERATED : July 28, 1995

VERITOOL COMPATIBILITY : Verilog2.0, Veritime1.4

*/

`delay_mode_path

`timescale  1 ns / 100 ps
`celldefine 
module ildx1 (q, d, g, ge, gsr);

    parameter size = 1;
    
    output   q;
    
    input    d, g, ge, gsr;
    
`protect

    // if not connected, default to 0
`ifdef SYNTH
`else
    tri0 gsr;
`endif

    reg  NOTIFY_REG;

    wire d_int;  

    U_MUX_2_1 INST_MUX (d_int, q, d, ge);
 
 
	// use a LATCH UDP that is reset to 0 on simulation time 0
	U_LD_N_S_R_NO_I0
            INST1 (q, d_int, g, gsr, 1'b0, NOTIFY_REG);

    not (_gsr, gsr);
    and (latch_en, _gsr, ge);

    specify

`ifdef SYNTH
    specparam Area = 1;
`endif

     // Specify path delays
     
	// d->q delay
	if (!gsr && ge && !g)
	    (d +=> q) = (1, 1);

	if (!gsr && ge)
	    (posedge g => (q +: d)) = (1, 1);
  
	if (!gsr && !g)
	    (posedge ge => (q +: d)) = (1, 1);
  
	(posedge gsr => (q +: 1'b0)) = (1, 1);

      
     // Timing Checks
     
        // setup and hold checks between d and the rising edge of g 
        // when gsr=0
	$setuphold(posedge g &&& latch_en, d, 1, 1, NOTIFY_REG);

        // setup and hold checks between the rising edge 
        // of ge and the rising edge of g
    $setuphold(posedge g &&& ~gsr, posedge ge, 1, 1, NOTIFY_REG);

        // setup and hold checks between the falling edge 
        // of gsr and the rising edge of g
    $setuphold(posedge g &&& ge, negedge gsr, 1, 1, NOTIFY_REG);

    // pulse width checks

	    // g high and low time when gsr=0
	$width(posedge g &&& latch_en, 1, 1, NOTIFY_REG);
	$width(negedge g &&& latch_en, 1, 1, NOTIFY_REG); 

	    // gsr high time
	$width(posedge gsr, 1, 1, NOTIFY_REG);

   
    endspecify

`endprotect

endmodule
`endcelldefine
