/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1990, 1991, 1992, 1993 and 1994 by      *
* Cadence Design Systems .                                                    *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

LIBRARY        : Xilinx XC4000 Library  - Rev 2.0 - Mar 1994.
FUNCTION       : D-FLIP-FLOP
	       : Instantiated in a higher level FF w/o the global signals
	       : to match the Composer symbol
REFERENCE      : The XNF Simulation Guide Dated Ver. 5.00 08/13/93.
                 
DESIGNER       : Udi Landen
DATE GENERATED : 1st Mar 1994 

VERITOOL COMPATIBILITY : Verilog2.0, Veritime1.4

*/

`delay_mode_path

`timescale  1 ns / 100 ps 
`celldefine     
module fdpe_int (q, c, ce, d, gsr, pre);

    output   q;
    
    input    c, ce, d, gsr, pre;

`protect

    // if not connected, default to 0
    tri0     pre, gsr;

    // if not connected, default to 1
    tri1     ce;

    reg  NOTIFY_REG;
    reg  PWR_UP_RST;
    
	// clear circuitry
	or  OR1 (PRESET, pre, gsr);

	// clock enable circuitry
	U_MUX_2_1 
	    INST1 (D_int, Q_int, d, ce);

	// use a FF UDP that is preset to 1 on simulation time 0
	U_FD_P_R_S_NO_I1
	    INST2 (Q_int, D_int, c, 1'b0, PRESET, NOTIFY_REG, PWR_UP_RST);
     
	buf BUFFER1 (q, Q_int);

	// Additional logic added for Timing Checks
	not NOT1 (PRESETB, PRESET);
	and AND2 (PRESETB_CE, PRESETB, ce);
    
	xor XOR1 (D_NEQ_Q, d, q);
	and AND3 (D_NEQ_Q_PRESETB, PRESETB, D_NEQ_Q);

    initial
        PWR_UP_RST = 0;

    specify

    // Specify path delays

	// d->q delay on posedge of clock
	if (!pre && !gsr && ce)
	    (posedge c => (q +: d)) = (1, 1);

	// preset FF with pre=1, q->1 delay
	(posedge pre => (q +: 1'b1)) = (1, 1);

	// preset FF with gsr=1,  q->1 delay
	(posedge gsr => (q +: 1'b1)) = (1, 1);
  
    // Timing Checks
 
	// setup and hold checks between d and the rising edge of clock 
	// when gsr=0 pre=0 ce=1
	$setuphold(posedge c &&& PRESETB_CE, d, 1, 1, NOTIFY_REG);


	// setup and hold checks between ce and the rising edge of clock 
	// when gsr=0 pre=0 and d!=q
	$setuphold(posedge c &&& D_NEQ_Q_PRESETB, ce, 1, 1, NOTIFY_REG);

	// setup and hold checks between the falling edge of pre and the rising edge of clock
	// when gsr=0 ce=1
	$setuphold(posedge c &&& PRESETB_CE, pre, 1, 1, NOTIFY_REG);

	// setup and hold checks between the falling edge of gsr and the rising edge of clock
	// when pre=0 ce=1
	$setuphold(posedge c &&& PRESETB_CE, gsr, 1, 1, NOTIFY_REG);
 
    // pulse width checks

	// clock high time when gsr=0 pre=0
	$width(posedge c &&& PRESETB, 1, 1, NOTIFY_REG);

	// clock low time when gsr=0 pre=0
	$width(negedge c &&& PRESETB, 1, 1, NOTIFY_REG);
 
	// gsr high time
	$width(posedge gsr, 1, 1, NOTIFY_REG);

	// pre high time when gsr=0
	$width(posedge pre &&& ~gsr, 1, 1, NOTIFY_REG);

    endspecify

`endprotect

endmodule
`endcelldefine
                                                                                                                                                 
