/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1990, 1991, 1992, 1993 and 1994 by      *
* Cadence Design Systems .                                                    *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

LIBRARY        : Xilinx XC4000 Library  - Rev 2.0 - Mar 1994.
FUNCTION       : Input D-FLIP-FLOP in the IOB
	       : Instantiated in a higher level FF w/o the global signals
	       : to match the Composer symbol
REFERENCE      : The XNF Simulation Guide Dated Ver. 5.00 08/13/93.
                 
DESIGNER       : Udi Landen
DATE GENERATED : 1st Mar 1994 

VERITOOL COMPATIBILITY : Verilog2.0, Veritime1.4

*/
       
`timescale  1 ns / 100 ps 
`celldefine 

module ifd_int (q, c, d, gsr);

    output   q;

    input    c, d, gsr;

`protect

    tri0 gsr;

    reg  NOTIFY_REG;
    
	// use a FF UDP that is reset to 0 on simulation time 0
	U_FD_P_R_S_NO_I0
	    INST1 (q, d, c, gsr, 1'b0, NOTIFY_REG);

    specify

    // Specify path delays

	// d->q delay on posedge of clock
	if (!gsr)
	    (posedge c => (q +: d)) = (1, 1);

	// reset FF,  q->0 delay
	(posedge gsr => (q +: 1'b0)) = (1, 1);
      
      
    // Timing Checks
     
	// setup and hold checks between d and the rising edge of clock when gsr=0
	$setuphold(posedge c &&& ~gsr, d, 1, 1, NOTIFY_REG);
 
	// setup and hold checks between the falling edge of gsr and the rising edge of clock
	$setuphold(posedge c &&& ~gsr, gsr, 1, 1, NOTIFY_REG);
 
    // pulse width checks

	// clock high time when gsr=0
	$width(posedge c &&& ~gsr, 1, 1, NOTIFY_REG);

	// clock low time when gsr=0
	$width(negedge c &&& ~gsr, 1, 1, NOTIFY_REG); 

	// gsr high time
	$width(posedge gsr, 1, 1, NOTIFY_REG);

    endspecify

`endprotect

endmodule
`endcelldefine


