/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1990, 1991, 1992, 1993 and 1994 by      *
* Cadence Design Systems .                                                    *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

LIBRARY        : Xilinx XC3000 Library  - Rev 2.0 - Mar 1994.
FUNCTION       : Input D-FLIP-FLOP in the IOB
	       : Instantiated in a higher level FF w/o the global signals
	       : to match the Composer symbol
REFERENCE      : The XNF Simulation Guide Dated Ver. 5.00 08/13/93.
                 
DESIGNER       : Udi Landen
DATE GENERATED : 1st Mar 1994 

VERITOOL COMPATIBILITY : Verilog2.0, Veritime1.4

*/
       
`delay_mode_path
 
`timescale  1 ns / 100 ps 
`celldefine     
module ifd_int (q, c, d, gr);

    output   q;

    input    c, d, gr;

`protect

    tri1 gr;

    reg  NOTIFY_REG;
    
         U_FD_P_RB_NO  INST1 (q, d, c, gr, NOTIFY_REG);
            
    
    specify

    // Specify path delays

	// d->q delay on posedge of clock
	if (gr)
	    (posedge c => (q +: d)) = (1, 1);

	// reset FF,  q->0 delay
	(negedge gr => (q +: 1'b0)) = (1, 1);
      
      
    // Timing Checks
     
	// setup and hold checks between d and the rising edge of clock when gr=1
	$setuphold(posedge c &&& gr, d, 1, 1, NOTIFY_REG);
 
	// setup and hold checks between the rising edge of gr and the rising edge of clock
	$setuphold(posedge c &&& gr, gr, 1, 1, NOTIFY_REG);
 
    // pulse width checks

	// clock high time when gr=1
	$width(posedge c &&& gr, 1, 1, NOTIFY_REG);

	// clock low time when gr=1
	$width(negedge c &&& gr, 1, 1, NOTIFY_REG); 

	// gr low time
	$width(negedge gr, 1, 1, NOTIFY_REG);

    endspecify

`endprotect

endmodule
`endcelldefine


