/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1990, 1991, 1992, 1993 and 1994 by      *
* Cadence Design Systems .                                                    *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

LIBRARY        : Xilinx XC3000 Library  - Rev 2.0 - Mar 1994.
FUNCTION       : D-FLIP-FLOP with Clock Enable
	       : Instantiated in a higher level FF w/o the global signals
	       : to match the Composer symbol
REFERENCE      : The XNF Simulation Guide Dated Ver. 5.00 08/13/93.
                 
DESIGNER       : Udi Landen
DATE GENERATED : 1st Mar 1994 

VERITOOL COMPATIBILITY : Verilog2.0, Veritime1.4

*/
`delay_mode_path

`timescale  1 ns / 100 ps 
`celldefine     
module fdce_int (q, c, ce, clr, d, gr);

    output   q;

    input    c, ce, clr, d, gr;

`protect

    // if not connected, default to 0
    tri0     clr;

    // if not connected, default to 1
    tri1     ce, gr;

    reg  NOTIFY_REG;

	// clear circuitry
	not  NOT1 (CLRB, clr);
	and  AND1 (RESET, CLRB, gr);
       
	U_MUX_2_1
	    INST1 (D_INT, Q_INT, d, ce);

	U_FD_P_RB_NO
	    INST2 (Q_INT, D_INT, c, RESET, NOTIFY_REG);
     
	buf BUFFER1 (q, Q_INT);

	// used for timing checks
	xor XOR1 (D_NEQ_Q, d, q);
	and AND2 (GR_CLRB_CE, RESET, ce);
	and AND3 (D_NEQ_Q_GR_CLRB, RESET, D_NEQ_Q);
    

    specify
    
    // Specify path delays

	// d->q delay on posedge of clock
	if (!clr && gr && ce)
	    (posedge c => (q +: d)) = (1, 1);

	// clear FF with clr=1, q->0 delay
	(posedge clr => (q +: 1'b0)) = (1, 1);

	// clear FF with gr=0,  q->0 delay
	(negedge gr => (q +: 1'b0)) = (1, 1);
      
     // Timing Checks
     
	// setup and hold checks between d and the rising edge of clock 
	// when gr=1 clr=0 ce=1
	$setuphold(posedge c &&& GR_CLRB_CE, d, 1, 1, NOTIFY_REG);

	// setup and hold checks between ce and the rising edge of clock 
	// when gr=1 clr=0 and d!=q
	    $setuphold(posedge c &&& D_NEQ_Q_GR_CLRB, ce, 1, 1, NOTIFY_REG);

	// setup and hold checks between the falling edge of clr and the rising edge of clock
	// when gr=1 ce=1
	$setuphold(posedge c &&& GR_CLRB_CE, clr, 1, 1, NOTIFY_REG);
 
	// setup and hold checks between the rising edge of gr and the rising edge of clock
	// when clr=0 ce=1
	$setuphold(posedge c &&& GR_CLRB_CE, gr, 1, 1, NOTIFY_REG);

    // pulse width checks

	// clock high time when gr=1 clr=0
	$width(posedge c &&& RESET, 1, 1, NOTIFY_REG);

	// clock low time when gr=1 clr=0
	$width(negedge c &&& RESET, 1, 1, NOTIFY_REG);

	// gr low time
	$width(negedge gr, 1, 1, NOTIFY_REG);

	// clear high time when gr=1
	$width(posedge clr &&& gr, 1, 1, NOTIFY_REG);

    endspecify

`endprotect

endmodule
`endcelldefine
                                                                                                                                                 

