-- UNBONDED_IO.VHD
-- Xilinx HDL Synthesis Design Guide for FPGAs
-- June 1995

-- XC4000 LCA has unbonded IOBs which have storage elements 
-- that can be used to build shift registers.
-- Below is a 4-bit Shift Register using Unbonded IOB Flip Flops

Library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;

entity unbonded_io is
    port (A, B: in STD_LOGIC;
	  CLK: in STD_LOGIC;
	  Q_OUT: out STD_LOGIC);
end unbonded_io;

architecture XILINX of unbonded_io is

    component IFD_U  -- Unbonded Input FF with INIT=Reset
  	port (Q: 	out std_logic;
       	      D, C: 	in  std_logic);
    end component;

    component IFDI_U -- Unbonded Input FF with INIT=Set
  	port (Q: 	out std_logic;
              D, C: 	in  std_logic);
    end component;

    component OFD_U -- Unbonded Output FF with INIT=Reset
  	port (Q: 	out std_logic;
              D, C: 	in  std_logic);
    end component;

    component OFDI_U -- Unbonded Output FF with INIT=Set
   	port (Q: 	out std_logic;
              D, C: 	in  std_logic);
    end component;

--- Internal Signal Declarations -----
    signal U_Q : STD_LOGIC_VECTOR (3 downto 0);
    signal U_D : STD_LOGIC;

begin
U_D <= A and B;
Q_OUT <= U_Q(0);

    U3: OFD_U  port map (Q => U_Q(3),
	       		 D => U_D,
			 C => CLK);

    U2: IFDI_U port map (Q => U_Q(2),
                         D => U_Q(3),
                         C => CLK);

    U1: OFDI_U port map (Q => U_Q(1),
                         D => U_Q(2),
                         C => CLK);

    U0: IFD_U  port map (Q => U_Q(0),
                         D => U_Q(1),
                         C => CLK);


end XILINX;
