-- RPM_RAM.VHD
-- Xilinx HDL Synthesis Design Guide for FPGAs
-- June 1995

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;

entity rpm_ram is
    port (CLOCK, CLEAR, ENABLE, WE: in STD_LOGIC;
          DATAIN: in STD_LOGIC_VECTOR(1 downto 0);
          DATAOUT: out STD_LOGIC_VECTOR(1 downto 0) );
end rpm_ram;

architecture rpm_ram_beh of rpm_ram is
   component RAM16X2
       port(DATA: in STD_LOGIC_VECTOR(1 downto 0);
            ADDR: in STD_LOGIC_VECTOR(3 downto 0);
            WE: in STD_LOGIC;
            DOUT: out STD_LOGIC_VECTOR(1 downto 0) );
   end component;
 
   component count4
       port(CLOCK: in STD_LOGIC;
            CLEAR: in STD_LOGIC;
            ENABLE: in STD_LOGIC;
            COUT : out STD_LOGIC_VECTOR(3 downto 0) );
   end component;

   signal  addr_to_ram : STD_LOGIC_VECTOR(3 downto 0);
   signal  ram_out     : STD_LOGIC_VECTOR(1 downto 0);

begin
   RAM_COMP : RAM16X2 port map(DATA => DATAIN,
                          ADDR => addr_to_ram,
                          WE   => WE,
                          DOUT => ram_out);

   INC_TO_RAM : count4 port map(CLOCK => CLOCK,
                                CLEAR => CLEAR,
                                ENABLE => ENABLE,
                                COUT => addr_to_ram);

   FF_OUT : process(CLOCK)
   begin
      if (CLOCK'event and CLOCK = '1') then
         DATAOUT <=  ram_out; 
      end if;
   end process; -- End of FF_OUT

end rpm_ram_beh;
