-- COUNT4.VHD
-- Xilinx HDL Synthesis Design Guide for FPGAs
-- 4-bit Counter with Enable and Clear
-- June 1995

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;

entity count4 is
   port (CLOCK, CLEAR, ENABLE : in std_logic;
         COUT : out std_logic_vector(3 downto 0));
end count4;

architecture COUNT4_BEH of count4 is
   signal QOUT : std_logic_vector(3 downto 0);
begin
   COUNT : process(CLEAR, CLOCK, ENABLE)
   begin
      if (CLEAR = '1') then
         QOUT <= "0000";
      elsif (CLOCK'event and CLOCK='1') then
         if (ENABLE = '1') then
            QOUT <= QOUT + 1;
         end if;
      end if;
   end process; -- End COUNT
   COUT <= QOUT;

end count4_beh;
