-- ROM_MEMGEN.VHD
-- Xilinx HDL Synthesis Design Guide for FPGAs
-- June 1995
-- Example of Instantiating a MemGen 

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;

entity rom_memgen is
    port (ADDR: in STD_LOGIC_VECTOR (3 downto 0);
	  DATA: out STD_LOGIC_VECTOR (3 downto 0));
end rom_memgen;	

architecture BEHAV of rom_memgen is

component promdata
    port (A3,A2,A1,A0: in STD_LOGIC;
	  O3,O2,O1,O0: out STD_LOGIC);
end component;

begin
    u1: promdata port map (A3=>ADDR(3),A2=>ADDR(2),A1=>ADDR(1),A0=>ADDR(0),
	O3=>DATA(3),O2=>DATA(2),O1=>DATA(1),O0=>DATA(0));

end BEHAV;
