-- USE_GSR_PRE example
-- Xilinx HDL Synthesis Design Guide for FPGAs
-- Modification of USE_GSR design so that the down
-- counter can be returned to an all "1" state by
-- either asserting the GSR pin of the STARTUP block
-- or by asserting an additional PRESET signal.
-- May 1995

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;

entity use_gsr_pre is
port ( CLOCK: in STD_LOGIC;
       PRESET: in STD_LOGIC;
       RESET: in STD_LOGIC;
       UPCNT: out STD_LOGIC_VECTOR (3 downto 0);
       DNCNT: out STD_LOGIC_VECTOR (3 downto 0));
end use_gsr_pre;

architecture SIMPLE of use_gsr_pre is

component STARTUP 
    port (GSR: in STD_LOGIC);
end component;

signal UP_CNT: STD_LOGIC_VECTOR (3 downto 0);
signal DN_CNT: STD_LOGIC_VECTOR (3 downto 0);

begin

    U1: STARTUP port map(gsr=>reset);
    UP_COUNTER: process(clock)

    begin
        if (CLOCK'event and CLOCK = '1') then
            UP_CNT <= UP_CNT + 1;
        end if;
    end process;

    DN_COUNTER: process(clock, preset) 
    begin
        if (PRESET='1') then
            DN_CNT<="1111";
        elsif (CLOCK'event and CLOCK = '1') then
            DN_CNT <= DN_CNT - 1;
        end if;
    end process;

    UPCNT <= UP_CNT;
    DNCNT <= DN_CNT;

-- RESET_COUNTERS: process (RESET)
-- begin
--    if (RESET = '1') then
--       UP_CNT <= "0000";
--       DN_CNT <= "1111";
--    end if;
--end process;

end SIMPLE;
