-- USE_GSR Example
-- Xilinx HDL Synthesis Design Guide for FPGAs
-- The signal RESET is connectet to the GSR pin of 
-- the STARTUP block
-- May 1995

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;

entity use_gsr is
port ( CLOCK: in STD_LOGIC;
       RESET: in STD_LOGIC;
       UPCNT: out STD_LOGIC_VECTOR (3 downto 0);
       DNCNT: out STD_LOGIC_VECTOR (3 downto 0));
end use_gsr;

architecture SIMPLE of use_gsr is

component STARTUP 
    port (GSR: in STD_LOGIC);
end component;

signal UP_CNT: STD_LOGIC_VECTOR (3 downto 0);
signal DN_CNT: STD_LOGIC_VECTOR (3 downto 0);

begin

    U1: STARTUP port map(gsr=>reset);

    UP_COUNTER: process(clock)
    begin
        if (CLOCK'event and CLOCK = '1') then
            UP_CNT <= UP_CNT + 1;
        end if;
    end process;

    DN_COUNTER: process(clock) 
    begin
        if (CLOCK'event and CLOCK = '1') then
            DN_CNT <= DN_CNT - 1;
        end if;
    end process;

    UPCNT <= UP_CNT;
    DNCNT <= DN_CNT;

--  RESET_COUNTERS: process (RESET)
--  begin
--      if (RESET = '1') then
--          UP_CNT <= "0000";
--          DN_CNT <= "1111";
--      end if;
--  end process;

end SIMPLE;
