-- FF_EXAMPLE.VHD
-- Xilinx HDL Synthesis Design Guide for FPGAs
-- June 1995
-- Example of Implementing Registers

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;

entity ff_example is
   port ( RESET, CLOCK, ENABLE: in STD_LOGIC;
	  D_IN: in STD_LOGIC_VECTOR (7 downto 0);
	  A_Q_OUT: out STD_LOGIC_VECTOR (7 downto 0);
	  B_Q_OUT: out STD_LOGIC_VECTOR (7 downto 0);
	  C_Q_OUT: out STD_LOGIC_VECTOR (7 downto 0);
	  D_Q_OUT: out STD_LOGIC_VECTOR (7 downto 0));
end ff_example;

architecture BEHAV of ff_example is
begin

    -- D flip-flop
    FF: process (CLOCK)
    begin
        if (CLOCK'event and CLOCK='1') then
            A_Q_OUT <= D_IN;
 	end if;
    end process; -- End FF

    -- Flip-flop with asynchronous reset
    FF_ASYNC_RESET: process (RESET, CLOCK)
    begin 
        if (RESET = '1') then
            B_Q_OUT <= "00000000";
	elsif (CLOCK'event and CLOCK='1') then
  	    B_Q_OUT <= D_IN;
	end if;
    end process; -- End FF_ASYNC_RESET
  
    -- Flip-flop with asynchronous set
    FF_ASYNC_SET: process (RESET, CLOCK) 
    begin
	if (RESET = '1') then
	     C_Q_OUT <= "11111111";
	elsif (CLOCK'event and CLOCK = '1') then
	     C_Q_OUT <= D_IN;
	end if;
    end process; -- End FF_ASYNC_SET

    -- Flip-flop with asynchronous reset and clock enable
    FF_CLOCK_ENABLE: process (ENABLE, RESET, CLOCK)
    begin
        if (RESET = '1') then
	    D_Q_OUT <= "00000000";
	elsif (CLOCK'event and CLOCK='1') then
	    if (ENABLE='1') then
	        D_Q_OUT <= D_IN;
    	    end if;
	end if;
    end process; -- End FF_CLOCK_ENABLE

end BEHAV;
