-- CASE_EX.VHD
-- Xilinx HDL Synthesis Design Guide for FPGAs
-- June 1995

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;

entity case_ex is
    port (SEL: in STD_LOGIC_VECTOR(1 downto 0);
	  A,B,C,D: in STD_LOGIC;
	  MUX_OUT: out STD_LOGIC);
end case_ex;

architecture BEHAV of case_ex is
begin

    CASE_PRO: process (SEL,A,B,C,D) 
    begin
        case SEL is
	    when "00" =>	MUX_OUT <= A;
	    when "01" =>  	MUX_OUT <= B;
	    when "10" =>  	MUX_OUT <= C;
	    when "11" =>  	MUX_OUT <= D;
	    when others=>  	MUX_OUT <= '0';
        end case;
    end process; --End CASE_PRO

end BEHAV;
