-- TIME_COUNTER.VHD
-- Xilinx HDL Synthesis Design Guide for FPGAs
-- June 1995

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;
use IEEE.std_logic_unsigned.all;

entity time_counter is
port ( HOURS, MINS, SECS, CLK : in STD_LOGIC;
       HOURS_OUT              : buffer INTEGER range 0 to 12;
       MINUTES_OUT            : buffer INTEGER range 0 to 59;
       AM_PM_OUT              : buffer STD_LOGIC);
end;

architecture BEHAVIOR of time_counter is

    signal  CURRENT_SECS : INTEGER range 0 to 59;

begin

    process 
    begin
        wait until CLK'event and CLK = '1';
	    HOURS_OUT <= HOURS_OUT;
	    AM_PM_OUT <= AM_PM_OUT;
	    MINUTES_OUT <= MINUTES_OUT;
	    CURRENT_SECS <= CURRENT_SECS;
	    if (SECS = '1' and MINS = '0' and HOURS = '0') then
	        if CURRENT_SECS = 59 then
	            CURRENT_SECS <= 0;
	            if MINUTES_OUT = 59 then
	                MINUTES_OUT <= 0;
		        if HOURS_OUT = 12 then
		            HOURS_OUT <= 1;
		            AM_PM_OUT <= not AM_PM_OUT;
		        else
		            HOURS_OUT <= HOURS_OUT + 1;
		        end if;
	            else
		        MINUTES_OUT <= MINUTES_OUT + 1;
	            end if;
	        else
	            CURRENT_SECS <= CURRENT_SECS + 1;
	        end if;
	    elsif (SECS = '0' and MINS = '1' and HOURS = '0') then
	        CURRENT_SECS <= 0;
	        if MINUTES_OUT = 59 then
	            MINUTES_OUT <= 0;
	            if HOURS_OUT = 12 then
	                HOURS_OUT <= 1;
		        AM_PM_OUT <= not AM_PM_OUT;
	            else
		        HOURS_OUT <= HOURS_OUT + 1;
	            end if;
	        else
	            MINUTES_OUT <= MINUTES_OUT + 1;
	        end if;
	    elsif (SECS = '0' and MINS = '0' and HOURS = '1') then
	        CURRENT_SECS <= 0;	
	        if HOURS_OUT = 12 then
	            HOURS_OUT <= 1;
	            AM_PM_OUT <= not AM_PM_OUT;
	        else
	            HOURS_OUT <= HOURS_OUT + 1;
	        end if;
            end if;
	 
    end process;

end BEHAVIOR;
