-- TIME_BLOCK.VHD
-- Xilinx HDL Synthesis Design Guide for FPGAs
-- June 1995

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;
use IEEE.std_logic_unsigned.all;

entity time_block is
port ( SET_TIME,HRS,MINS,CLK : in STD_LOGIC;
       CONNECT6              : buffer INTEGER range 1 to 12;
       CONNECT7              : buffer INTEGER range 0 to 59;
       CONNECT8              : buffer STD_LOGIC);
end;

architecture BEHAVIOR of time_block is
    component time_state_machine
    port( TIME_BUTTON    : in STD_LOGIC;
          HOURS_BUTTON   : in STD_LOGIC;
	  MINUTES_BUTTON : in STD_LOGIC;
	  CLK            : in STD_LOGIC;
	  SECS           : out STD_LOGIC;
	  HOURS          : out STD_LOGIC;
	  MINS           : out STD_LOGIC);
    end component;

    component time_counter 
    port( SECS        : in STD_LOGIC;
	  HOURS       : in STD_LOGIC;
	  MINS        : in STD_LOGIC;
	  CLK         : in STD_LOGIC;
	  HOURS_OUT   : buffer INTEGER range 1 to 12;
	  MINUTES_OUT : buffer INTEGER range 0 to 59;
	  AM_PM_OUT   : buffer STD_LOGIC);
    end component;

-- Top level nets that connect major modules 

    signal CONNECT3,CONNECT4,CONNECT5 : STD_LOGIC;

    begin
	U1: time_state_machine port map(SET_TIME,HRS,MINS,CLK,
		CONNECT5,CONNECT3,CONNECT4);

	U2: TIME_COUNTER port map (CONNECT5, CONNECT3,CONNECT4,
		CLK,CONNECT6,CONNECT7,CONNECT8);

end;
