-- ALARM_COUNTER.VHD
-- Xilinx HDL Synthesis Design Guide for FPGAs
-- June 1995

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;
use IEEE.std_logic_unsigned.all;

entity alarm_counter is
port ( HOURS, MINS, CLK : in STD_LOGIC;
       HOURS_OUT        : buffer INTEGER range 1 to 12;
       MINUTES_OUT      : buffer INTEGER range 0 to 59;
       AM_PM_OUT        : buffer STD_LOGIC);
end;

architecture BEHAVIOR of alarm_counter is
begin

   process
   begin
     wait until CLK'event and CLK = '1';

	MINUTES_OUT <= MINUTES_OUT;
	HOURS_OUT <= HOURS_OUT;
	AM_PM_OUT <= AM_PM_OUT;

	if (MINS = '1' and HOURS = '0') then
	   if MINUTES_OUT = 59 then
	      MINUTES_OUT <= 0;
	      if HOURS_OUT = 12 then
		 HOURS_OUT <= 1;
		 AM_PM_OUT <= not AM_PM_OUT;
	      else
		 HOURS_OUT <= HOURS_OUT + 1;
	      end if;
	   else
	      MINUTES_OUT <= MINUTES_OUT + 1;
	   end if;
	elsif (HOURS = '1' and MINS = '0') then
	   if HOURS_OUT = 12 then
	      HOURS_OUT <= 1;
	      AM_PM_OUT <= not AM_PM_OUT;
	   else
	      HOURS_OUT <= HOURS_OUT + 1;
	   end if;
	end if;

   end process;

end BEHAVIOR;
