

primitive U_LD_P_S_I1 (Q, D, G, S, NOTI_REG); 

 

    output Q; 
    input  D,               // DATA
           G,               // CLOCK
           S,              // PRESET ACTIVE HIGH
           NOTI_REG;        // NOTIFY REG

`protect

    reg    Q;                               

// FUNCTION : D-LATCH, GATED  CLEAR DIRECT /GATE ACTIVE HIGH ( Q OUTPUT UDP ) 
//

// Initialize the output pin Q to logical value 1
initial
    Q=1'b1;

   table
     //  D       G      S    NOTI_REG       : Qt  :   Qt+1

         *       0      0      ?             :  ?  :    -   ;

         ?       ?      1      ?             :  ?  :    1   ; // asynchro preset

         ?      (?0)    0      ?             :  ?  :    -   ;
         ?      (1x)    0      ?             :  ?  :    -   ;

         0      (0x)    0      ?             :  0  :    0   ;
         1      (0x)    0      ?             :  1  :    1   ;
         0      (x1)    0      ?             :  ?  :    0   ;
         1      (x1)    0      ?             :  ?  :    1   ;

        (?0)     1      0      ?             :  ?  :    0   ;
        (?1)     1      0      ?             :  ?  :    1   ; 
         0      (01)    0      ?             :  ?  :    0   ;
         1      (01)    0      ?             :  ?  :    1   ; 

         0       ?      x      ?             :  0  :    0   ;   // Reducing pessimism.
         0      (?1)    x      ?             :  ?  :    0   ;   // Reducing pessimism.
        (?0)     1      x      ?             :  ?  :    0   ;   // Reducing pessimism.

         ?       0     (?0)    ?             :  ?  :    -   ;   // ignore edge on clear
         0       1     (?0)    ?             :  ?  :    0   ;   // pessimism .
         1       1     (?0)    ?             :  ?  :    1   ;  

        (?1)     x      0      ?             :  1  :    1   ;   // Reducing pessimism.
        (?0)     x      0      ?             :  0  :    0   ;   // Reducing pessimism.
         
         ?       ?      ?      *             :  ?  :    x   ;

   endtable

`endprotect

endprimitive
