/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1990, 1991, 1992, 1993 and 1994 by      *
* Cadence Design Systems .                                                    *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

LIBRARY        : Xilinx XC4000 Library  - Rev 2.0 - Mar 1994.
FUNCTION       : RAM 32x1
REFERENCE      : The XNF Simulation Guide Dated Ver. 5.00 08/13/93.
                 
DESIGNER       : Udi Landen
DATE GENERATED : 1st Mar 1994 

VERITOOL COMPATIBILITY : Verilog2.0, Veritime1.4

*/

`delay_mode_path

`timescale  1 ns / 100 ps 
`celldefine
module ram32x1 (o, a0, a1, a2, a3, a4, d, we);

    parameter size = 1,
              init = 0;
    
  output   o;
    
  input    a0, a1, a2, a3, a4, d, we;

`protect

  reg  VIOLATION;
  reg  mem [0:31];
  wire [4:0] adr;
  reg [4:0] adrs;
  wire din, wen;

  reg  [5:0] count;
   
  reg dout;
    
    buf b1 (din, d);
    buf b2 (wen,we);
    buf b3 (adr[4],a4);
    buf b4 (adr[3],a3);
    buf b5 (adr[2],a2);
    buf b6 (adr[1],a1);
    buf b7 (adr[0],a0);
    buf b8 (o, dout);

//    initial
//    begin
//        for(count = 0; count < 32; count = count + 1)
//            mem[count] = init;
//    end

    always @ (din or adr or wen)
      begin
        if (wen)
        // read during write (pass d to o)
            assign dout = din;
        else
        // read (read from current address
            assign dout = mem[adr];
      end

//    assign dout = mem[adr]; 

    always @ (VIOLATION)
      mem[adr] = 1'bx;

    // write into memory on address during negedge we
    always @ (negedge wen)
        mem[adrs] = din;
 
    // store address for write during posedge we
    always @ (posedge wen)
        adrs = adr;


    specify
    
	// Specify path delays

	if (we)
	    (d => o) = (1, 1);

	(a4 => o) = (1, 1);
	(a3 => o) = (1, 1);
	(a2 => o) = (1, 1);
	(a1 => o) = (1, 1);
	(a0 => o) = (1, 1);

	(posedge we => (o +: d)) = (1, 1);

	// Timing Checks
     

	// setup and hold checks between d and the falling edge of we
	$setuphold(negedge we, d, 1, 1, VIOLATION);

	// setup checks between address (a) and rising edge of we
	// hold checks between address (a) and falling edge of we
	// address stability checks (a should remain stable through 
	// the period the we is high
	$setuphold(posedge we, a4, 0, 0, VIOLATION);
	$setuphold(negedge we, a4, 0, 0, VIOLATION);
	$setuphold(posedge we, a3, 0, 0, VIOLATION);
	$setuphold(negedge we, a3, 0, 0, VIOLATION);
	$setuphold(posedge we, a2, 0, 0, VIOLATION);
	$setuphold(negedge we, a2, 0, 0, VIOLATION);
	$setuphold(posedge we, a1, 0, 0, VIOLATION);
	$setuphold(negedge we, a1, 0, 0, VIOLATION);
	$setuphold(posedge we, a0, 0, 0, VIOLATION);
	$setuphold(negedge we, a0, 0, 0, VIOLATION);
     
	// we high time
	$width(posedge we, 1, 1, VIOLATION);

    endspecify

`endprotect

endmodule
`endcelldefine

